import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeHttpsHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#check_interval_sec ComputeHttpsHealthCheck#check_interval_sec}
     *
     * @stability stable
     */
    readonly checkIntervalSec?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#description ComputeHttpsHealthCheck#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#healthy_threshold ComputeHttpsHealthCheck#healthy_threshold}
     *
     * @stability stable
     */
    readonly healthyThreshold?: number;
    /**
     * The value of the host header in the HTTPS health check request.
     *
     * If
     * left empty (default value), the public IP on behalf of which this
     * health check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#host ComputeHttpsHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#name ComputeHttpsHealthCheck#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The TCP port number for the HTTPS health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#port ComputeHttpsHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#project ComputeHttpsHealthCheck#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The request path of the HTTPS health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#request_path ComputeHttpsHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * How long (in seconds) to wait before claiming failure.
     *
     * The default value is 5 seconds.  It is invalid for timeoutSec to have
     * greater value than checkIntervalSec.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#timeout_sec ComputeHttpsHealthCheck#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#unhealthy_threshold ComputeHttpsHealthCheck#unhealthy_threshold}
     *
     * @stability stable
     */
    readonly unhealthyThreshold?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#timeouts ComputeHttpsHealthCheck#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeHttpsHealthCheckTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeHttpsHealthCheckTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#create ComputeHttpsHealthCheck#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#delete ComputeHttpsHealthCheck#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#update ComputeHttpsHealthCheck#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeHttpsHealthCheckTimeoutsToTerraform(struct?: ComputeHttpsHealthCheckTimeoutsOutputReference | ComputeHttpsHealthCheckTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeHttpsHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeHttpsHealthCheckTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeHttpsHealthCheckTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html google_compute_https_health_check}.
 *
 * @stability stable
 */
export declare class ComputeHttpsHealthCheck extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html google_compute_https_health_check} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeHttpsHealthCheckConfig);
    private _checkIntervalSec?;
    /**
     * @stability stable
     */
    get checkIntervalSec(): number;
    /**
     * @stability stable
     */
    set checkIntervalSec(value: number);
    /**
     * @stability stable
     */
    resetCheckIntervalSec(): void;
    /**
     * @stability stable
     */
    get checkIntervalSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    /**
     * @stability stable
     */
    get healthyThreshold(): number;
    /**
     * @stability stable
     */
    set healthyThreshold(value: number);
    /**
     * @stability stable
     */
    resetHealthyThreshold(): void;
    /**
     * @stability stable
     */
    get healthyThresholdInput(): number | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    set requestPath(value: string);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    set timeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    private _unhealthyThreshold?;
    /**
     * @stability stable
     */
    get unhealthyThreshold(): number;
    /**
     * @stability stable
     */
    set unhealthyThreshold(value: number);
    /**
     * @stability stable
     */
    resetUnhealthyThreshold(): void;
    /**
     * @stability stable
     */
    get unhealthyThresholdInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeHttpsHealthCheckTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeHttpsHealthCheckTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeHttpsHealthCheckTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
