import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleCloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * A user-defined name of the function. Function names must be unique globally.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html#name DataGoogleCloudfunctionsFunction#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Project of the function. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html#project DataGoogleCloudfunctionsFunction#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region of function. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html#region DataGoogleCloudfunctionsFunction#region}
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get retry(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudfunctionsFunctionEventTrigger extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    get failurePolicy(): any;
    /**
     * @stability stable
     */
    get resource(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudfunctionsFunctionSourceRepository extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get deployedUrl(): string;
    /**
     * @stability stable
     */
    get url(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html google_cloudfunctions_function}.
 *
 * @stability stable
 */
export declare class DataGoogleCloudfunctionsFunction extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html google_cloudfunctions_function} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudfunctionsFunctionConfig);
    /**
     * @stability stable
     */
    get availableMemoryMb(): number;
    /**
     * @stability stable
     */
    buildEnvironmentVariables(key: string): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get entryPoint(): string;
    /**
     * @stability stable
     */
    environmentVariables(key: string): string;
    /**
     * @stability stable
     */
    eventTrigger(index: string): DataGoogleCloudfunctionsFunctionEventTrigger;
    /**
     * @stability stable
     */
    get httpsTriggerUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ingressSettings(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get maxInstances(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get runtime(): string;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string;
    /**
     * @stability stable
     */
    get sourceArchiveBucket(): string;
    /**
     * @stability stable
     */
    get sourceArchiveObject(): string;
    /**
     * @stability stable
     */
    sourceRepository(index: string): DataGoogleCloudfunctionsFunctionSourceRepository;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    get triggerHttp(): any;
    /**
     * @stability stable
     */
    get vpcConnector(): string;
    /**
     * @stability stable
     */
    get vpcConnectorEgressSettings(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
