import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeBackendBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket.html#name DataGoogleComputeBackendBucket#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket.html#project DataGoogleComputeBackendBucket#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get code(): number;
    /**
     * @stability stable
     */
    get ttl(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendBucketCdnPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cacheMode(): string;
    /**
     * @stability stable
     */
    get clientTtl(): number;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    get maxTtl(): number;
    /**
     * @stability stable
     */
    get negativeCaching(): any;
    /**
     * @stability stable
     */
    get negativeCachingPolicy(): any;
    /**
     * @stability stable
     */
    get serveWhileStale(): number;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSec(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket.html google_compute_backend_bucket}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeBackendBucket extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_backend_bucket.html google_compute_backend_bucket} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeBackendBucketConfig);
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    cdnPolicy(index: string): DataGoogleComputeBackendBucketCdnPolicy;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    /**
     * @stability stable
     */
    get customResponseHeaders(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get enableCdn(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
