import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EndpointsServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The full text of the Service Config YAML file (Example located here).
     *
     * If provided, must also provide protoc_output_base64. open_api config must not be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#grpc_config EndpointsService#grpc_config}
     *
     * @stability stable
     */
    readonly grpcConfig?: string;
    /**
     * The full text of the OpenAPI YAML configuration as described here.
     *
     * Either this, or both of grpc_config and protoc_output_base64 must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#openapi_config EndpointsService#openapi_config}
     *
     * @stability stable
     */
    readonly openapiConfig?: string;
    /**
     * The project ID that the service belongs to. If not provided, provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#project EndpointsService#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The full contents of the Service Descriptor File generated by protoc. This should be a compiled .pb file, base64-encoded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#protoc_output_base64 EndpointsService#protoc_output_base64}
     *
     * @stability stable
     */
    readonly protocOutputBase64?: string;
    /**
     * The name of the service. Usually of the form $apiname.endpoints.$projectid.cloud.goog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#service_name EndpointsService#service_name}
     *
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#timeouts EndpointsService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EndpointsServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class EndpointsServiceApisMethods extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get requestType(): string;
    /**
     * @stability stable
     */
    get responseType(): string;
    /**
     * @stability stable
     */
    get syntax(): string;
}
/**
 * @stability stable
 */
export declare class EndpointsServiceApis extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get methods(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get syntax(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export declare class EndpointsServiceEndpoints extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface EndpointsServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#create EndpointsService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#delete EndpointsService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html#update EndpointsService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function endpointsServiceTimeoutsToTerraform(struct?: EndpointsServiceTimeoutsOutputReference | EndpointsServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class EndpointsServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EndpointsServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EndpointsServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html google_endpoints_service}.
 *
 * @stability stable
 */
export declare class EndpointsService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service.html google_endpoints_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EndpointsServiceConfig);
    /**
     * @stability stable
     */
    apis(index: string): EndpointsServiceApis;
    /**
     * @stability stable
     */
    get configId(): string;
    /**
     * @stability stable
     */
    get dnsAddress(): string;
    /**
     * @stability stable
     */
    endpoints(index: string): EndpointsServiceEndpoints;
    private _grpcConfig?;
    /**
     * @stability stable
     */
    get grpcConfig(): string;
    /**
     * @stability stable
     */
    set grpcConfig(value: string);
    /**
     * @stability stable
     */
    resetGrpcConfig(): void;
    /**
     * @stability stable
     */
    get grpcConfigInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _openapiConfig?;
    /**
     * @stability stable
     */
    get openapiConfig(): string;
    /**
     * @stability stable
     */
    set openapiConfig(value: string);
    /**
     * @stability stable
     */
    resetOpenapiConfig(): void;
    /**
     * @stability stable
     */
    get openapiConfigInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocOutputBase64?;
    /**
     * @stability stable
     */
    get protocOutputBase64(): string;
    /**
     * @stability stable
     */
    set protocOutputBase64(value: string);
    /**
     * @stability stable
     */
    resetProtocOutputBase64(): void;
    /**
     * @stability stable
     */
    get protocOutputBase64Input(): string | undefined;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EndpointsServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EndpointsServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EndpointsServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
