import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TagsTagKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * User-assigned description of the TagKey. Must not exceed 256 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#description TagsTagKey#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Input only. The resource name of the new TagKey's parent. Must be of the form organizations/{org_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#parent TagsTagKey#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * Input only.
     *
     * The user friendly name for a TagKey. The short name should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#short_name TagsTagKey#short_name}
     *
     * @stability stable
     */
    readonly shortName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#timeouts TagsTagKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TagsTagKeyTimeouts;
}
/**
 * @stability stable
 */
export interface TagsTagKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#create TagsTagKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#delete TagsTagKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#update TagsTagKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function tagsTagKeyTimeoutsToTerraform(struct?: TagsTagKeyTimeoutsOutputReference | TagsTagKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class TagsTagKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TagsTagKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TagsTagKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html google_tags_tag_key}.
 *
 * @stability stable
 */
export declare class TagsTagKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html google_tags_tag_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TagsTagKeyConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get namespacedName(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _shortName?;
    /**
     * @stability stable
     */
    get shortName(): string;
    /**
     * @stability stable
     */
    set shortName(value: string);
    /**
     * @stability stable
     */
    get shortNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TagsTagKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TagsTagKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TagsTagKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
