from pathlib import Path

from immuneML.data_model.dataset.Dataset import Dataset
from immuneML.reports.Report import Report


class DataReport(Report):
    """
    Data reports show some type of features or statistics about a given dataset.

    When running the :ref:`TrainMLModel` instruction, data reports can be specified under the key 'data_reports', to run the
    report on the whole dataset, or inside the 'selection' or 'assessment' specification under the keys 'reports/data' (current cross-validation split) or 'reports/data_splits' (train/test sub-splits).

    Alternatively, when running the :ref:`ExploratoryAnalysis` instruction, data reports can be specified under 'reports'.

    When using the reports with instructions such as ExploratoryAnalysis or TrainMLModel, the arguments defined below are set at runtime by the instruction.
    Concrete classes inheriting DataReport may include additional parameters that will be set by the user in the form of input arguments.

    Arguments:

        dataset (Dataset): a dataset object (can be repertoire, receptor or sequence dataset, depending on the specific report)

        result_path (Path): location where the results (plots, tables, etc.) will be stored

        name (str): user-defined name of the report used in the HTML overview automatically generated by the platform

    """

    def __init__(self, dataset: Dataset = None, result_path: Path = None, name: str = None):
        super().__init__(name)
        self.dataset = dataset
        self.result_path = result_path

    @staticmethod
    def get_title():
        return "Data reports"
