from pathlib import Path
from typing import List

from immuneML.hyperparameter_optimization.states.TrainMLModelState import TrainMLModelState
from immuneML.reports.Report import Report


class MultiDatasetReport(Report):
    """
    Multi dataset reports are special reports that can be specified when running immuneML with the :py:obj:`~immuneML.api.aggregated_runs.MultiDatasetBenchmarkTool.MultiDatasetBenchmarkTool`.

    When running the :py:obj:`~immuneML.api.aggregated_runs.MultiDatasetBenchmarkTool.MultiDatasetBenchmarkTool`, multi dataset reports can be specified under 'benchmark_reports'.

    When using the reports with MultiDatasetBenchmarkTool, the arguments defined below are set at runtime by the instruction.
    Concrete classes inheriting MultiDatasetReport may include additional parameters that will be set by the user in the form of input arguments.

    Arguments:

        name (str): user-defined name of the report used in the HTML overview automatically generated by the platform

        result_path (Path): location where the report results will be stored

        instruction_states (list): a list of states for each instruction that was run as a part of the tool, e.g., TrainMLModelState objects

    """

    def __init__(self, instruction_states: List[TrainMLModelState] = None, name: str = None, result_path: Path = None):
        super().__init__(name)
        self.instruction_states = instruction_states
        self.result_path = result_path

    @staticmethod
    def get_title():
        return "Multi dataset reports"
