from pathlib import Path

from immuneML.hyperparameter_optimization.states.TrainMLModelState import TrainMLModelState
from immuneML.reports.Report import Report


class TrainMLModelReport(Report):
    """
    Train ML model reports plot general statistics or export data of multiple models simultaneously when running the :ref:`TrainMLModel` instruction.

    In the :ref:`TrainMLModel` instruction, train ML model reports can be specified under 'reports'.

    When using the reports with TrainMLModel instruction, the arguments defined below are set at runtime by the instruction.
    Concrete classes inheriting TrainMLModelReport may include additional parameters that will be set by the user in the form of input arguments.

    Arguments:

        name (str): user-defined name of the report used in the HTML overview automatically generated by the platform

        state (TrainMLModelState): a state object that includes all the information, trained models, encodings and datasets from the nested cross-validation procedure used to train the optimal model.

        result_path (Path): location where the report results will be stored

    """

    def __init__(self, name: str = None, state: TrainMLModelState = None, result_path: Path = None):
        super().__init__(name)
        self.state = state
        self.result_path = result_path

    @staticmethod
    def get_title():
        return "Train ML model reports"
