"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stage = exports.MethodLoggingLevel = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const access_log_1 = require("./access-log");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
const util_1 = require("./util");
var MethodLoggingLevel;
(function (MethodLoggingLevel) {
    MethodLoggingLevel["OFF"] = "OFF";
    MethodLoggingLevel["ERROR"] = "ERROR";
    MethodLoggingLevel["INFO"] = "INFO";
})(MethodLoggingLevel = exports.MethodLoggingLevel || (exports.MethodLoggingLevel = {}));
class Stage extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_StageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Stage);
            }
            throw error;
        }
        this.enableCacheCluster = props.cacheClusterEnabled;
        const methodSettings = this.renderMethodSettings(props); // this can mutate `this.cacheClusterEnabled`
        // custom access logging
        let accessLogSetting;
        const accessLogDestination = props.accessLogDestination;
        const accessLogFormat = props.accessLogFormat;
        if (!accessLogDestination && !accessLogFormat) {
            accessLogSetting = undefined;
        }
        else {
            if (accessLogFormat !== undefined &&
                !core_1.Token.isUnresolved(accessLogFormat.toString()) &&
                !/.*\$context.requestId.*/.test(accessLogFormat.toString())) {
                throw new Error('Access log must include at least `AccessLogFormat.contextRequestId()`');
            }
            if (accessLogFormat !== undefined && accessLogDestination === undefined) {
                throw new Error('Access log format is specified without a destination');
            }
            accessLogSetting = {
                destinationArn: accessLogDestination?.bind(this).destinationArn,
                format: accessLogFormat?.toString() ? accessLogFormat?.toString() : access_log_1.AccessLogFormat.clf().toString(),
            };
        }
        // enable cache cluster if cacheClusterSize is set
        if (props.cacheClusterSize !== undefined) {
            if (this.enableCacheCluster === undefined) {
                this.enableCacheCluster = true;
            }
            else if (this.enableCacheCluster === false) {
                throw new Error(`Cannot set "cacheClusterSize" to ${props.cacheClusterSize} and "cacheClusterEnabled" to "false"`);
            }
        }
        const cacheClusterSize = this.enableCacheCluster ? (props.cacheClusterSize || '0.5') : undefined;
        const resource = new apigateway_generated_1.CfnStage(this, 'Resource', {
            stageName: props.stageName || 'prod',
            accessLogSetting,
            cacheClusterEnabled: this.enableCacheCluster,
            cacheClusterSize,
            clientCertificateId: props.clientCertificateId,
            deploymentId: props.deployment.deploymentId,
            restApiId: props.deployment.api.restApiId,
            description: props.description,
            documentationVersion: props.documentationVersion,
            variables: props.variables,
            tracingEnabled: props.tracingEnabled,
            methodSettings,
        });
        this.stageName = resource.ref;
        this.restApi = props.deployment.api;
        if (restapi_1.RestApiBase._isRestApiBase(this.restApi)) {
            this.restApi._attachStage(this);
        }
    }
    /**
     * Returns the invoke URL for a certain path.
     * @param path The resource path
     */
    urlForPath(path = '/') {
        if (!path.startsWith('/')) {
            throw new Error(`Path must begin with "/": ${path}`);
        }
        return `https://${this.restApi.restApiId}.execute-api.${core_1.Stack.of(this).region}.${core_1.Stack.of(this).urlSuffix}/${this.stageName}${path}`;
    }
    /**
     * Returns the resource ARN for this stage:
     *
     *   arn:aws:apigateway:{region}::/restapis/{restApiId}/stages/{stageName}
     *
     * Note that this is separate from the execute-api ARN for methods and resources
     * within this stage.
     *
     * @attribute
     */
    get stageArn() {
        return core_1.Stack.of(this).formatArn({
            arnFormat: core_1.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME,
            service: 'apigateway',
            account: '',
            resource: 'restapis',
            resourceName: `${this.restApi.restApiId}/stages/${this.stageName}`,
        });
    }
    renderMethodSettings(props) {
        const settings = new Array();
        const self = this;
        // extract common method options from the stage props
        const commonMethodOptions = {
            metricsEnabled: props.metricsEnabled,
            loggingLevel: props.loggingLevel,
            dataTraceEnabled: props.dataTraceEnabled,
            throttlingBurstLimit: props.throttlingBurstLimit,
            throttlingRateLimit: props.throttlingRateLimit,
            cachingEnabled: props.cachingEnabled,
            cacheTtl: props.cacheTtl,
            cacheDataEncrypted: props.cacheDataEncrypted,
        };
        // if any of them are defined, add an entry for '/*/*'.
        const hasCommonOptions = Object.keys(commonMethodOptions).map(v => commonMethodOptions[v]).filter(x => x).length > 0;
        if (hasCommonOptions) {
            settings.push(renderEntry('/*/*', commonMethodOptions));
        }
        if (props.methodOptions) {
            for (const path of Object.keys(props.methodOptions)) {
                settings.push(renderEntry(path, props.methodOptions[path]));
            }
        }
        return settings.length === 0 ? undefined : settings;
        function renderEntry(path, options) {
            if (options.cachingEnabled) {
                if (self.enableCacheCluster === undefined) {
                    self.enableCacheCluster = true;
                }
                else if (self.enableCacheCluster === false) {
                    throw new Error(`Cannot enable caching for method ${path} since cache cluster is disabled on stage`);
                }
            }
            const { httpMethod, resourcePath } = util_1.parseMethodOptionsPath(path);
            return {
                httpMethod,
                resourcePath,
                cacheDataEncrypted: options.cacheDataEncrypted,
                cacheTtlInSeconds: options.cacheTtl && options.cacheTtl.toSeconds(),
                cachingEnabled: options.cachingEnabled,
                dataTraceEnabled: options.dataTraceEnabled ?? false,
                loggingLevel: options.loggingLevel,
                metricsEnabled: options.metricsEnabled,
                throttlingBurstLimit: options.throttlingBurstLimit,
                throttlingRateLimit: options.throttlingRateLimit,
            };
        }
    }
}
exports.Stage = Stage;
_a = JSII_RTTI_SYMBOL_1;
Stage[_a] = { fqn: "@aws-cdk/aws-apigateway.Stage", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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