"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("@aws-cdk/aws-stepfunctions");
const _1 = require(".");
const stepfunctions_1 = require("./integrations/stepfunctions");
/**
 * Defines an API Gateway REST API with a Synchrounous Express State Machine as a proxy integration.
 */
class StepFunctionsRestApi extends _1.RestApi {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_StepFunctionsRestApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsRestApi);
            }
            throw error;
        }
        if (props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Step Functions integration is automatically defined');
        }
        if (props.stateMachine.node.defaultChild.stateMachineType !== sfn.StateMachineType.EXPRESS) {
            throw new Error('State Machine must be of type "EXPRESS". Please use StateMachineType.EXPRESS as the stateMachineType');
        }
        const stepfunctionsIntegration = stepfunctions_1.StepFunctionsIntegration.startExecution(props.stateMachine, {
            credentialsRole: props.role,
            requestContext: props.requestContext,
            path: props.path ?? true,
            querystring: props.querystring ?? true,
            headers: props.headers,
            authorizer: props.authorizer,
        });
        super(scope, id, props);
        this.root.addMethod('ANY', stepfunctionsIntegration);
    }
}
exports.StepFunctionsRestApi = StepFunctionsRestApi;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.StepFunctionsRestApi", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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