"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcLink = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 */
class VpcLink extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.vpcLinkName ||
                core_1.Lazy.string({ produce: () => core_1.Names.nodeUniqueId(this.node) }),
        });
        this._targets = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_VpcLinkProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcLink);
            }
            throw error;
        }
        const cfnResource = new apigateway_generated_1.CfnVpcLink(this, 'Resource', {
            name: this.physicalName,
            description: props.description,
            targetArns: core_1.Lazy.list({ produce: () => this.renderTargets() }),
        });
        this.vpcLinkId = cfnResource.ref;
        if (props.targets) {
            this.addTargets(...props.targets);
        }
    }
    /**
     * Import a VPC Link by its Id
     */
    static fromVpcLinkId(scope, id, vpcLinkId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.vpcLinkId = vpcLinkId;
            }
        }
        return new Import(scope, id);
    }
    addTargets(...targets) {
        this._targets.push(...targets);
    }
    /**
     * Return the list of DNS names from the target NLBs.
     * @internal
     * */
    get _targetDnsNames() {
        return this._targets.map(t => t.loadBalancerDnsName);
    }
    validate() {
        if (this._targets.length === 0) {
            return ['No targets added to vpc link'];
        }
        return [];
    }
    renderTargets() {
        return this._targets.map(nlb => nlb.loadBalancerArn);
    }
}
exports.VpcLink = VpcLink;
_a = JSII_RTTI_SYMBOL_1;
VpcLink[_a] = { fqn: "@aws-cdk/aws-apigateway.VpcLink", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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