"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceEndpointAclPolicy = exports.InstanceEndpointAclPolicyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cr_generated_1 = require("./cr.generated");
Object.defineProperty(exports, "InstanceEndpointAclPolicyProperty", { enumerable: true, get: function () { return cr_generated_1.RosInstanceEndpointAclPolicy; } });
/**
 * A ROS resource type:  `ALIYUN::CR::InstanceEndpointAclPolicy`
 */
class InstanceEndpointAclPolicy extends ros.Resource {
    /**
     * Create a new `ALIYUN::CR::InstanceEndpointAclPolicy`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstanceEndpointAclPolicy = new cr_generated_1.RosInstanceEndpointAclPolicy(this, id, {
            comment: props.comment,
            entry: props.entry,
            instanceId: props.instanceId,
            moduleName: props.moduleName === undefined || props.moduleName === null ? 'Registry' : props.moduleName,
            endpointType: props.endpointType === undefined || props.endpointType === null ? 'internet' : props.endpointType,
            regionId: props.regionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstanceEndpointAclPolicy;
        this.attrEntry = rosInstanceEndpointAclPolicy.attrEntry;
        this.attrInstanceId = rosInstanceEndpointAclPolicy.attrInstanceId;
    }
}
exports.InstanceEndpointAclPolicy = InstanceEndpointAclPolicy;
//# sourceMappingURL=data:application/json;base64,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