/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import bridge.ReproJson;
import bridge.ReproJsonParser;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import log.Logger;
import log.LoggerTypes;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u001d\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lbridge/ReproJsonParser;", "", "()V", "logger", "Llog/Logger;", "getJsonElementFromReproJson", "Lkotlinx/serialization/json/JsonElement;", "jsonStr", "", "elemStr", "parseFromFile", "Lbridge/ReproJson;", "reproFileName", "parseReproSettings", "", "certoraMetaDataElem", "(Lkotlinx/serialization/json/JsonElement;)[Ljava/lang/String;", "ReproParserException", "Shared"})
public final class ReproJsonParser {
    @NotNull
    public static final ReproJsonParser INSTANCE = new ReproJsonParser();
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.RUN_REPRO);

    private ReproJsonParser() {
    }

    @NotNull
    public final ReproJson parseFromFile(@NotNull String reproFileName) {
        Intrinsics.checkNotNullParameter(reproFileName, "reproFileName");
        if (!FileUtils.fileExists(reproFileName)) {
            throw new ReproParserException("run-repro file " + reproFileName + " was specified in cmd line but does not exist");
        }
        FileReader reader = new FileReader(reproFileName);
        String reproJsonStr = TextStreamsKt.readText(reader);
        JsonElement certoraMetaDataElem = this.getJsonElementFromReproJson(reproJsonStr, "certoraMetaData");
        JsonElement certoraBuildElem = this.getJsonElementFromReproJson(reproJsonStr, "certoraBuild");
        JsonElement certoraVerifyElem = this.getJsonElementFromReproJson(reproJsonStr, "certoraVerify");
        JsonElement certoraConfigElem = this.getJsonElementFromReproJson(reproJsonStr, "certoraConfig");
        if (certoraBuildElem == null || certoraVerifyElem == null || certoraConfigElem == null) {
            throw new ReproParserException("run-repro file " + reproFileName + " contained unparsable element");
        }
        return new ReproJson(certoraMetaDataElem, certoraBuildElem, certoraVerifyElem, certoraConfigElem);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String[] parseReproSettings(@Nullable JsonElement certoraMetaDataElem) {
        try {
            void $this$flatMapTo$iv$iv;
            Object object;
            JsonArray jsonArray;
            JsonObject jsonObject;
            JsonElement jsonElement;
            Object object2;
            JsonElement jsonElement2 = certoraMetaDataElem;
            JsonArray jsonArray2 = jsonElement2 == null ? null : ((object2 = JsonElementKt.getJsonObject(jsonElement2)) == null ? null : ((jsonElement = (JsonElement)((JsonObject)object2).get((Object)"args")) == null ? null : ((jsonObject = JsonElementKt.getJsonObject(jsonElement)) == null ? null : (jsonArray = (object = (JsonElement)jsonObject.get((Object)"settings")) == null ? null : JsonElementKt.getJsonArray((JsonElement)object)))));
            if (jsonArray == null) {
                return null;
            }
            JsonArray settings = jsonArray;
            Iterable $this$flatMap$iv = (Iterable)JsonKt.Json$default(null, parseReproSettings.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.ListSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE)), settings.toString());
            boolean $i$f$flatMap = false;
            object2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }
        catch (Exception e) {
            logger.warn(e, parseReproSettings.3.INSTANCE);
            return null;
        }
    }

    private final JsonElement getJsonElementFromReproJson(String jsonStr, String elemStr) {
        try {
            JsonObject jsonObject;
            JsonElement reproduction;
            JsonObject jsonObj = JsonElementKt.getJsonObject(Json.Default.parseToJsonElement(jsonStr));
            JsonElement jsonElement = reproduction = (JsonElement)jsonObj.get((Object)"reproduction");
            return jsonElement == null ? null : ((jsonObject = JsonElementKt.getJsonObject(jsonElement)) == null ? null : (JsonElement)jsonObject.get((Object)elemStr));
        }
        catch (Exception e) {
            String errMsg = Intrinsics.stringPlus("ReproJsonParser could not parse json element ", elemStr);
            logger.error((Throwable)e, (Function0<? extends Object>)new Function0<Object>(errMsg){
                final /* synthetic */ String $errMsg;
                {
                    this.$errMsg = $errMsg;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$errMsg;
                }
            });
            throw new ReproParserException(errMsg);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lbridge/ReproJsonParser$ReproParserException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errMsg", "", "(Ljava/lang/String;)V", "Shared"})
    public static final class ReproParserException
    extends Exception {
        public ReproParserException(@NotNull String errMsg) {
            Intrinsics.checkNotNullParameter(errMsg, "errMsg");
            super(errMsg);
        }
    }
}

