/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Cmd;
import com.certora.evmverifier.cvl.MethodParamFiltersMap;
import com.certora.evmverifier.cvl.NamedParam;
import com.certora.evmverifier.cvl.Param;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java_cup.runtime.ComplexSymbolFactory;
import kotlinizable.Kotlinizable;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLRuleType;
import spec.cvlast.CVLSingleRule;
import spec.cvlast.IRule;
import spec.cvlast.SingleRuleGenerationMeta;

public class Rule
implements Kotlinizable<IRule> {
    private final String specFile;
    private final Boolean isImportedSpecFile;
    private final ComplexSymbolFactory.Location loc;
    private final String id;
    private final List<NamedParam> params;
    private final MethodParamFiltersMap methodParamFilters;
    private final String description;
    private final String goodDescription;
    private final List<Cmd> block;

    public Rule(String _specFile, Boolean _isImportedSpecFile, ComplexSymbolFactory.Location _loc, String _id, List<Param> _params, MethodParamFiltersMap _methodParamFilters, String _description, String _goodDescription, List<Cmd> _block) {
        this.specFile = _specFile;
        this.isImportedSpecFile = _isImportedSpecFile;
        this.loc = _loc;
        this.id = _id;
        this.params = NamedParam.paramsToNamedParams(_specFile, _loc, _params);
        this.methodParamFilters = _methodParamFilters;
        this.description = _description;
        this.goodDescription = _goodDescription;
        this.block = _block;
    }

    public String toString() {
        Stream<String> paramsListToString = this.params.stream().map(Objects::toString);
        return String.format("Rule(%s,%s,%s,%s)", this.id, paramsListToString.reduce("", (S, s) -> S + ", " + s), this.description, this.goodDescription);
    }

    @Override
    public IRule kotlinize() {
        return new CVLSingleRule(CVLLocation.Companion.fromLocationAndSpecFile(this.loc, this.specFile), this.id, Kotlinizer.kotlinizeList(this.params), this.description != null ? this.description : "", this.goodDescription != null ? this.goodDescription : "", Kotlinizer.kotlinizeList(this.block), this.isImportedSpecFile != false ? CVLRuleType.Single.FromUser.ImportedSpecFile.INSTANCE : CVLRuleType.Single.FromUser.SpecFile.INSTANCE, null, null, this.methodParamFilters.kotlinize(), SingleRuleGenerationMeta.Empty.INSTANCE);
    }
}

