/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.SlotPattern;
import com.certora.evmverifier.cvl.StaticSlotPatternElement;
import com.certora.evmverifier.cvl.StaticSlotPatternNamed;
import com.certora.evmverifier.cvl.StaticSlotPatternNumber;
import com.certora.evmverifier.cvl.StaticSlotPatternTwoNumbers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java_cup.runtime.ComplexSymbolFactory;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLSlotPattern;
import spec.cvlast.SolidityContract;

public class StaticSlotPattern
extends SlotPattern {
    private static final String SLOT = "slot";
    private static final String OFFSET = "offset";
    private final List<StaticSlotPatternElement> elements = new ArrayList<StaticSlotPatternElement>();

    public StaticSlotPattern(String _specFile, ComplexSymbolFactory.Location _loc) {
        super(_specFile, _loc);
    }

    public void add(StaticSlotPatternElement e) {
        this.elements.add(e);
    }

    private String loc() {
        if (this.loc == null) {
            return "null";
        }
        if (this.specFile != null) {
            return String.format("%s:%s", this.specFile, this.loc);
        }
        return this.loc.toString();
    }

    @Override
    public CVLSlotPattern kotlinize() {
        StaticSlotPatternElement first2 = null;
        StaticSlotPatternElement second = null;
        if (this.elements.size() > 0) {
            first2 = this.elements.get(0);
        }
        if (this.elements.size() > 1) {
            second = this.elements.get(1);
        }
        if (this.elements.size() == 1) {
            if (first2.getClass() == StaticSlotPatternNamed.class) {
                return new CVLSlotPattern.Static.Named(SolidityContract.Current.INSTANCE, ((StaticSlotPatternNamed)first2).name);
            }
            if (first2.getClass() == StaticSlotPatternNumber.class) {
                return new CVLSlotPattern.Static.Indexed(SolidityContract.Current.INSTANCE, (CVLExp.Constant.NumberLit)((StaticSlotPatternNumber)first2).number.kotlinize(), new CVLExp.Constant.NumberLit(BigInteger.ZERO, CVLExpTag.Companion.getEmptyTag()));
            }
            if (first2.getClass() == StaticSlotPatternTwoNumbers.class) {
                return new CVLSlotPattern.Static.Indexed(SolidityContract.Current.INSTANCE, (CVLExp.Constant.NumberLit)((StaticSlotPatternTwoNumbers)first2).number1.kotlinize(), (CVLExp.Constant.NumberLit)((StaticSlotPatternTwoNumbers)first2).number2.kotlinize());
            }
            this.check(false, "missed case at " + this.loc());
        } else {
            if (this.elements.size() > 1) {
                CVLSlotPattern curr = null;
                if (first2 instanceof StaticSlotPatternNamed) {
                    SolidityContract contract = ((StaticSlotPatternNamed)first2).name.equals("currentContract") ? SolidityContract.Current.INSTANCE : new SolidityContract.Named(((StaticSlotPatternNamed)first2).name);
                    if (second instanceof StaticSlotPatternNamed) {
                        curr = new CVLSlotPattern.Static.Named(contract, ((StaticSlotPatternNamed)second).name);
                    } else if (second instanceof StaticSlotPatternNumber) {
                        if (((StaticSlotPatternNumber)second).prefix.equals(SLOT)) {
                            curr = new CVLSlotPattern.Static.Indexed(contract, (CVLExp.Constant.NumberLit)((StaticSlotPatternNumber)second).number.kotlinize(), new CVLExp.Constant.NumberLit(BigInteger.ZERO, CVLExpTag.Companion.getEmptyTag()));
                        } else {
                            this.check(((StaticSlotPatternNumber)second).prefix.equals(OFFSET), "keyword should either be 'slot' or 'offset' at " + this.loc());
                            curr = new CVLSlotPattern.StructAccess(new CVLSlotPattern.Static.Named(SolidityContract.Current.INSTANCE, ((StaticSlotPatternNamed)first2).name), (CVLExp.Constant.NumberLit)((StaticSlotPatternNumber)second).number.kotlinize());
                        }
                    } else if (second instanceof StaticSlotPatternTwoNumbers) {
                        this.check(((StaticSlotPatternTwoNumbers)second).prefix1.equals(SLOT) && ((StaticSlotPatternTwoNumbers)second).prefix2.equals(OFFSET), "Static slot must be of the form '(slot X, offset Y)' at " + this.loc());
                        curr = new CVLSlotPattern.Static.Indexed(contract, (CVLExp.Constant.NumberLit)((StaticSlotPatternTwoNumbers)second).number1.kotlinize(), (CVLExp.Constant.NumberLit)((StaticSlotPatternTwoNumbers)second).number2.kotlinize());
                    } else {
                        this.check(false, "missed case at " + this.loc());
                    }
                } else if (first2 instanceof StaticSlotPatternNumber) {
                    this.check(((StaticSlotPatternNumber)first2).prefix.equals(SLOT), "static slot must have the form '(slot X)' at " + this.loc());
                    this.check(second.getClass() == StaticSlotPatternNumber.class && ((StaticSlotPatternNumber)second).prefix.equals(OFFSET), "static slot must be followed by struct offset or array/map dereference at " + this.loc());
                    curr = new CVLSlotPattern.StructAccess(new CVLSlotPattern.Static.Indexed(SolidityContract.Current.INSTANCE, (CVLExp.Constant.NumberLit)((StaticSlotPatternNumber)first2).number.kotlinize(), new CVLExp.Constant.NumberLit(BigInteger.ZERO, CVLExpTag.Companion.getEmptyTag())), (CVLExp.Constant.NumberLit)((StaticSlotPatternNumber)second).number.kotlinize());
                } else if (first2.getClass() == StaticSlotPatternTwoNumbers.class) {
                    this.check(((StaticSlotPatternTwoNumbers)first2).prefix1.equals(SLOT) && ((StaticSlotPatternTwoNumbers)first2).prefix2.equals(OFFSET), "static slot must have the form '(slot X, offset Y)' at " + this.loc());
                    this.check(second.getClass() == StaticSlotPatternNumber.class && ((StaticSlotPatternNumber)second).prefix.equals(OFFSET), "static slot must be followed by struct offset or array/map dereference at " + this.loc());
                    curr = new CVLSlotPattern.StructAccess(new CVLSlotPattern.Static.Indexed(SolidityContract.Current.INSTANCE, (CVLExp.Constant.NumberLit)((StaticSlotPatternTwoNumbers)first2).number1.kotlinize(), (CVLExp.Constant.NumberLit)((StaticSlotPatternTwoNumbers)first2).number2.kotlinize()), (CVLExp.Constant.NumberLit)((StaticSlotPatternNumber)second).number.kotlinize());
                } else {
                    this.check(false, "missed case at " + this.loc());
                }
                for (int i = 2; i < this.elements.size(); ++i) {
                    StaticSlotPatternElement el = this.elements.get(i);
                    assert (curr != null);
                    String msg = "pattern " + curr + " must be followed by a sequence of (offset X) or field names " + this.loc();
                    if (el instanceof StaticSlotPatternNumber) {
                        StaticSlotPatternNumber num = (StaticSlotPatternNumber)el;
                        this.check(num.prefix.equals(OFFSET), msg);
                        curr = new CVLSlotPattern.StructAccess(curr, (CVLExp.Constant.NumberLit)num.number.kotlinize());
                        continue;
                    }
                    if (el instanceof StaticSlotPatternNamed) {
                        curr = new CVLSlotPattern.FieldAccess(curr, ((StaticSlotPatternNamed)el).name);
                        continue;
                    }
                    this.check(false, msg);
                }
                return curr;
            }
            this.check(false, "missed case at " + this.loc());
        }
        assert (false);
        return null;
    }

    private void check(boolean condition, String failureMsg) {
        if (!condition) {
            System.out.println(failureMsg);
            System.out.println("Failed to parse CVL file. Exiting.");
            System.exit(1);
        }
    }
}

