/*
 * Decompiled with CFR 0.152.
 */
package log;

import allocator.Allocator;
import config.Config;
import config.ConfigType;
import evm.EVMConstsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import log.ArtifactLocation;
import log.ArtifactManager;
import log.ArtifactManagerFactory;
import log.Logger;
import log.LoggerTypes;
import log.VersionedArtifact;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.IRule;
import tac.DebuggableProgram;
import tac.DumpType;
import tac.TACFile;
import utils.ArtifactFileUtils;
import utils.CertoraFileCache;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 D2\u00020\u0001:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016J(\u0010!\u001a\u00020\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\u0006\u0010'\u001a\u00020\u0013H\u0016J \u0010(\u001a\u0004\u0018\u00010\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&J-\u0010(\u001a\u0004\u0018\u00010\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\u0006\u0010)\u001a\u0002H#\u00a2\u0006\u0002\u0010*J7\u0010(\u001a\u0004\u0018\u00010\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\u0006\u0010)\u001a\u0002H#2\u0006\u0010'\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010+J5\u0010,\u001a\u00020\"\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\u0006\u0010)\u001a\u0002H#2\u0006\u0010'\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010+J\u0014\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000400J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0010\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u00104\u001a\u00020\u0015J&\u00105\u001a\u00020\u0004\"\b\b\u0000\u0010#*\u0002062\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H#002\u0006\u00107\u001a\u000208J\u0014\u00105\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000400J\u000e\u00105\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u00105\u001a\u00020\u00042\u0006\u00109\u001a\u0002062\u0006\u00107\u001a\u000208J\u0010\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0018\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u00109\u001a\u0002062\u0006\u00107\u001a\u000208J\u0010\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u00104\u001a\u00020\u0015J\u0018\u0010;\u001a\n <*\u0004\u0018\u00010\u00040\u00042\u0006\u0010=\u001a\u00020\u0013H\u0004J\u0014\u0010>\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000400J\u0018\u0010>\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u0013J\u0018\u0010>\u001a\u00020\u001e2\u0006\u00109\u001a\u0002062\b\b\u0002\u0010'\u001a\u00020\u0013J\u000e\u0010?\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0015J(\u0010@\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0004002\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0BJ$\u0010@\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00042\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0BH\u0016J,\u0010@\u001a\u00020\u001e2\u0006\u00109\u001a\u0002062\u0006\u00107\u001a\u0002082\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0BH\u0016J\"\u0010@\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u00152\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0BJ\"\u0010C\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0BR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006\u00a8\u0006E"}, d2={"Llog/ArtifactManager;", "", "()V", "debugDir", "", "getDebugDir", "()Ljava/lang/String;", "formulasDir", "getFormulasDir", "inputsDir", "getInputsDir", "mainPath", "getMainPath", "mainReportsDir", "getMainReportsDir", "outputDir", "getOutputDir", "registeredArtifacts", "Ljava/util/concurrent/ConcurrentMap;", "Llog/ArtifactLocation;", "rulesToRegisteredOutputArtifacts", "Lspec/cvlast/IRule;", "treeViewReportsDir", "getTreeViewReportsDir", "artifactPathOf", "loc", "name", "artifactPathOfOrNull", "locOrNull", "backup", "", "fileName", "backupFileName", "dumpBinary", "Ltac/TACFile;", "T", "Ltac/DumpType;", "p", "Ltac/DebuggableProgram;", "location", "dumpCodeArtifacts", "dumpType", "(Ltac/DebuggableProgram;Ltac/DumpType;)Ltac/TACFile;", "(Ltac/DebuggableProgram;Ltac/DumpType;Llog/ArtifactLocation;)Ltac/TACFile;", "dumpMandatoryCodeArtifacts", "getArtifactHandle", "Ljava/io/OutputStreamWriter;", "conf", "Lconfig/ConfigType;", "getArtifactHandleStream", "Ljava/io/OutputStream;", "getRegisteredArtifactNameOrNull", "rule", "getRegisteredArtifactPath", "Llog/VersionedArtifact;", "version", "", "versionedArtifact", "getRegisteredArtifactPathOrNull", "getWhere", "kotlin.jvm.PlatformType", "l", "registerArtifact", "registerRuleOutputArtifact", "useArtifact", "action", "Lkotlin/Function1;", "useTempArtifact", "Companion", "Shared"})
public abstract class ArtifactManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, ArtifactLocation> registeredArtifacts = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentMap<IRule, String> rulesToRegisteredOutputArtifacts = new ConcurrentHashMap();
    @NotNull
    private static final String RULE_OUTPUT_BASE_NAME = "rule_output_";
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.COMMON);

    @NotNull
    public abstract String getMainPath();

    protected final String getWhere(@NotNull ArtifactLocation l) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)l, "l");
        ArtifactLocation artifactLocation = l;
        int n = WhenMappings.$EnumSwitchMapping$0[artifactLocation.ordinal()];
        if (n == 1) {
            string2 = System.getProperty("user.dir");
        } else if (l.isDefault()) {
            string2 = l.get(this.getMainPath());
        } else {
            File file = new File(l.get());
            boolean bl = false;
            boolean bl2 = false;
            File f = file;
            boolean bl3 = false;
            string2 = f.isAbsolute() ? f.getAbsolutePath() : l.get(".");
        }
        return string2;
    }

    @NotNull
    public String getMainReportsDir() {
        String string2 = this.getWhere(ArtifactLocation.REPORTS);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(ArtifactLocation.REPORTS)");
        return string2;
    }

    @NotNull
    public String getTreeViewReportsDir() {
        String string2 = this.getWhere(ArtifactLocation.TREE_VIEW_REPORTS);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(ArtifactLocation.TREE_VIEW_REPORTS)");
        return string2;
    }

    @NotNull
    public String getOutputDir() {
        String string2 = this.getWhere(ArtifactLocation.OUTPUTS);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(ArtifactLocation.OUTPUTS)");
        return string2;
    }

    @NotNull
    public String getDebugDir() {
        String string2 = this.getWhere(ArtifactLocation.DEBUGS);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(ArtifactLocation.DEBUGS)");
        return string2;
    }

    @NotNull
    public String getFormulasDir() {
        String string2 = this.getWhere(ArtifactLocation.FORMULAS);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(ArtifactLocation.FORMULAS)");
        return string2;
    }

    @NotNull
    public String getInputsDir() {
        String string2 = this.getWhere(ArtifactLocation.INPUT);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(ArtifactLocation.INPUT)");
        return string2;
    }

    @Nullable
    public final <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return this.dumpCodeArtifacts(p, p.getDefaultType());
    }

    @Nullable
    public final <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        return this.dumpCodeArtifacts(p, dumpType, ArtifactLocation.DEBUGS);
    }

    @Nullable
    public <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull ArtifactLocation location) {
        TACFile tACFile;
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        if (!((Boolean)Config.INSTANCE.getLowFootprint().get()).booleanValue() && dumpType.isEnabled()) {
            String string2 = this.getWhere(location);
            Intrinsics.checkNotNullExpressionValue(string2, "getWhere(location)");
            tACFile = p.dump(dumpType, string2);
        } else {
            tACFile = null;
        }
        return tACFile;
    }

    @NotNull
    public <T extends DumpType> TACFile dumpMandatoryCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull ArtifactLocation location) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        String string2 = this.getWhere(location);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(location)");
        return p.dump(dumpType, string2);
    }

    @NotNull
    public <T extends DumpType> TACFile dumpBinary(@NotNull DebuggableProgram<T> p, @NotNull ArtifactLocation location) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        String string2 = this.getWhere(location);
        Intrinsics.checkNotNullExpressionValue(string2, "getWhere(location)");
        return p.dumpBinary(string2);
    }

    private final String artifactPathOf(ArtifactLocation loc, String name) {
        return this.getWhere(loc) + File.separator + name;
    }

    private final String artifactPathOfOrNull(ArtifactLocation locOrNull, String name) {
        String string2;
        ArtifactLocation artifactLocation = locOrNull;
        if (artifactLocation == null) {
            string2 = null;
        } else {
            ArtifactLocation artifactLocation2 = artifactLocation;
            boolean bl = false;
            boolean bl2 = false;
            ArtifactLocation loc = artifactLocation2;
            boolean bl3 = false;
            string2 = this.artifactPathOf(loc, name);
        }
        return string2;
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.artifactPathOfOrNull((ArtifactLocation)((Object)this.registeredArtifacts.get(name)), name);
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull VersionedArtifact versionedArtifact, int version) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        return this.artifactPathOfOrNull((ArtifactLocation)((Object)this.registeredArtifacts.get(versionedArtifact.getUnversionedName())), versionedArtifact.getVersionedNameBuilder().invoke(version));
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getRegisteredArtifactPath(conf.get());
    }

    @NotNull
    public final <T extends VersionedArtifact> String getRegisteredArtifactPath(@NotNull ConfigType<T> conf, int version) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getRegisteredArtifactPath((VersionedArtifact)conf.get(), version);
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = this.getRegisteredArtifactPathOrNull(name);
        return string2 == null ? "N/A" : string2;
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull VersionedArtifact versionedArtifact, int version) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        String string2 = this.getRegisteredArtifactPathOrNull(versionedArtifact, version);
        return string2 == null ? "N/A" : string2;
    }

    public final void registerArtifact(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        this.registerArtifact(conf.get(), !Intrinsics.areEqual(conf.get(), conf.getDefault()) ? ArtifactLocation.CWD : ArtifactLocation.REPORTS);
    }

    public final void registerArtifact(@NotNull String name, @NotNull ArtifactLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        this.registeredArtifacts.putIfAbsent(name, location);
    }

    public static /* synthetic */ void registerArtifact$default(ArtifactManager artifactManager, String string2, ArtifactLocation artifactLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerArtifact");
        }
        if ((n & 2) != 0) {
            artifactLocation = ArtifactLocation.REPORTS;
        }
        artifactManager.registerArtifact(string2, artifactLocation);
    }

    public final void registerArtifact(@NotNull VersionedArtifact versionedArtifact, @NotNull ArtifactLocation location) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        this.registerArtifact(versionedArtifact.getUnversionedName(), location);
    }

    public static /* synthetic */ void registerArtifact$default(ArtifactManager artifactManager, VersionedArtifact versionedArtifact, ArtifactLocation artifactLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerArtifact");
        }
        if ((n & 2) != 0) {
            artifactLocation = ArtifactLocation.REPORTS;
        }
        artifactManager.registerArtifact(versionedArtifact, artifactLocation);
    }

    public final void registerRuleOutputArtifact(@NotNull IRule rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        Map map2 = this.rulesToRegisteredOutputArtifacts;
        boolean bl = false;
        Map map3 = map2;
        boolean bl2 = false;
        if (!map3.containsKey(rule)) {
            String outputFilename = RULE_OUTPUT_BASE_NAME + Allocator.INSTANCE.getFreshId(Allocator.Id.RULE_OUTPUT) + ".json";
            Map map4 = this.rulesToRegisteredOutputArtifacts;
            boolean bl3 = false;
            map4.put(rule, outputFilename);
            this.registeredArtifacts.putIfAbsent(outputFilename, ArtifactLocation.TREE_VIEW_REPORTS);
        }
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull IRule rule) {
        String string2;
        Intrinsics.checkNotNullParameter(rule, "rule");
        String string3 = this.getRegisteredArtifactNameOrNull(rule);
        if (string3 == null) {
            string2 = null;
        } else {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String p0 = string4;
            boolean bl3 = false;
            string2 = this.getRegisteredArtifactPathOrNull(p0);
        }
        return string2;
    }

    @Nullable
    public final String getRegisteredArtifactNameOrNull(@NotNull IRule rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        return (String)this.rulesToRegisteredOutputArtifacts.get(rule);
    }

    public final void useArtifact(@NotNull IRule rule, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        Intrinsics.checkNotNullParameter(action, "action");
        String ruleOutputPath = this.getRegisteredArtifactPathOrNull(rule);
        if (ruleOutputPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(rule){
                final /* synthetic */ IRule $rule;
                {
                    this.$rule = $rule;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use output artifact for rule " + this.$rule.getDeclarationId() + ", since this rule has not been registered.";
                }
            });
            return;
        }
        action.invoke(ruleOutputPath);
    }

    public final void useArtifact(@NotNull ConfigType<String> conf, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        Intrinsics.checkNotNullParameter(action, "action");
        this.useArtifact(conf.get(), action);
    }

    public void useArtifact(@NotNull VersionedArtifact versionedArtifact, int version, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        Intrinsics.checkNotNullParameter(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(versionedArtifact, version);
        if (fullPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(version, versionedArtifact){
                final /* synthetic */ int $version;
                final /* synthetic */ VersionedArtifact $versionedArtifact;
                {
                    this.$version = $version;
                    this.$versionedArtifact = $versionedArtifact;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use versioned artifact (version=" + this.$version + "), since " + this.$versionedArtifact.getUnversionedName() + " is not a valid file name.";
                }
            });
            return;
        }
        action.invoke(fullPath);
    }

    public void useArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use artifact, since " + this.$name + " is not a valid file name.";
                }
            });
            return;
        }
        action.invoke(fullPath);
    }

    @NotNull
    public final OutputStreamWriter getArtifactHandle(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getArtifactHandle(conf.get());
    }

    @NotNull
    public OutputStreamWriter getArtifactHandle(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new OutputStreamWriter(this.getArtifactHandleStream(name));
    }

    @NotNull
    public OutputStream getArtifactHandleStream(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            String string2 = Intrinsics.stringPlus("Non existing artifact ", name);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return new FileOutputStream(fullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(@NotNull String fileName, @NotNull String backupFileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(backupFileName, "backupFileName");
        try {
            Reader reader = CertoraFileCache.INSTANCE.getContentReader(EVMConstsKt.prepend_internal_dir(fileName));
            Closeable closeable = reader;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                long l;
                Reader it = (Reader)closeable;
                boolean bl3 = false;
                File backupFileDir = new File(FileUtils.dirname(backupFileName));
                backupFileDir.mkdirs();
                Reader reader2 = it;
                Object object = new File(backupFileName);
                Charset charset = Charsets.UTF_8;
                int n = 8192;
                boolean bl4 = false;
                Object object2 = object;
                boolean bl5 = false;
                Object object3 = object2;
                boolean bl6 = false;
                object3 = new FileOutputStream((File)object3);
                bl6 = false;
                object2 = new OutputStreamWriter((OutputStream)object3, charset);
                bl5 = false;
                BufferedWriter writer = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                object = writer;
                boolean bl7 = false;
                n = 0;
                Throwable throwable2 = null;
                try {
                    BufferedWriter it2 = (BufferedWriter)object;
                    boolean bl8 = false;
                    l = TextStreamsKt.copyTo$default(reader2, writer, 0, 2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            Logger.Companion.alwaysError("Received exception " + e + "; Failed to backup " + fileName, e);
        }
    }

    @NotNull
    public final String useTempArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(action, "action");
        File tmpFile = File.createTempFile(name, null);
        tmpFile.deleteOnExit();
        String string2 = tmpFile.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "tmpFile.path");
        action.invoke(string2);
        string2 = tmpFile.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "tmpFile.path");
        return string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llog/ArtifactManager$Companion;", "", "()V", "RULE_OUTPUT_BASE_NAME", "", "logger", "Llog/Logger;", "copyInputsToRootOfOutputDir", "", "filenames", "", "getCmdErrorFilepath", "name", "getCmdOutputFilepath", "getFilePathForSmtQuery", "subdir", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCmdOutputFilepath(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return ArtifactManagerFactory.INSTANCE.invoke().getDebugDir() + File.separator + "Cmd_" + name + ".out.txt";
        }

        @NotNull
        public final String getCmdErrorFilepath(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return ArtifactManagerFactory.INSTANCE.invoke().getDebugDir() + File.separator + "Cmd_" + name + ".err.txt";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void copyInputsToRootOfOutputDir(@NotNull List<String> filenames) {
            Intrinsics.checkNotNullParameter(filenames, "filenames");
            if (ArtifactManagerFactory.INSTANCE.isEnabled()) {
                String target = ArtifactManagerFactory.INSTANCE.invoke().getMainPath();
                try {
                    Iterable $this$forEach$iv = filenames;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String filename = (String)element$iv;
                        boolean bl = false;
                        String targetFile = target + File.separator + ArtifactFileUtils.INSTANCE.getBasenameOnly(filename) + '.' + FileUtils.extension(filename);
                        Reader reader = CertoraFileCache.INSTANCE.getContentReader(filename);
                        Closeable closeable = reader;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Throwable throwable = null;
                        try {
                            Reader it = (Reader)closeable;
                            boolean bl4 = false;
                            Object object = new File(targetFile);
                            Charset charset = Charsets.UTF_8;
                            int n = 8192;
                            boolean bl5 = false;
                            Object object2 = object;
                            boolean bl6 = false;
                            Object object3 = object2;
                            boolean bl7 = false;
                            object3 = new FileOutputStream((File)object3);
                            bl7 = false;
                            object2 = new OutputStreamWriter((OutputStream)object3, charset);
                            bl6 = false;
                            BufferedWriter writer = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                            object = writer;
                            boolean bl8 = false;
                            n = 0;
                            Throwable throwable2 = null;
                            try {
                                BufferedWriter it2 = (BufferedWriter)object;
                                boolean bl9 = false;
                                TextStreamsKt.copyTo$default(reader, it2, 0, 2, null);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, throwable2);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to copy some inputs files " + filenames + ", got error: " + e.getMessage());
                }
            }
        }

        @NotNull
        public final String getFilePathForSmtQuery(@NotNull String name, @Nullable String subdir) {
            String string2;
            String subdirString;
            String string3;
            Intrinsics.checkNotNullParameter(name, "name");
            String string4 = subdir;
            if (string4 == null) {
                string3 = "";
            } else {
                String string5 = string4;
                boolean bl = false;
                boolean bl2 = false;
                String it = string5;
                boolean bl3 = false;
                String string6 = Intrinsics.stringPlus(File.separator, it);
                string3 = subdirString = string6 == null ? "" : string6;
            }
            if (!ArtifactManagerFactory.INSTANCE.isEnabled()) {
                string2 = ArtifactManagerFactory.INSTANCE.invoke().useTempArtifact(Intrinsics.stringPlus((String)Config.INSTANCE.getFormulaFileBasename().get(), subdirString), getFilePathForSmtQuery.1.INSTANCE);
            } else {
                String baseDir = Intrinsics.stringPlus(ArtifactManagerFactory.INSTANCE.invoke().getFormulasDir(), subdirString);
                String basePathPrefix = baseDir + File.separator + (String)Config.INSTANCE.getFormulaFileBasename().get() + '_' + Allocator.INSTANCE.getFreshNumber() + '_';
                String smt2file = basePathPrefix + name + ".smt2";
                int fileLengthLimitWindows = 250;
                if (SystemUtils.IS_OS_WINDOWS && smt2file.length() > fileLengthLimitWindows) {
                    logger.warn((Function0<? extends Object>)new Function0<Object>(name, fileLengthLimitWindows){
                        final /* synthetic */ String $name;
                        final /* synthetic */ int $fileLengthLimitWindows;
                        {
                            this.$name = $name;
                            this.$fileLengthLimitWindows = $fileLengthLimitWindows;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "Cannot dump .smt2 file for " + this.$name + ", since we're on Windows and file namewould be too long. (assumed length limit: " + this.$fileLengthLimitWindows + ')';
                        }
                    });
                    return "";
                }
                File baseDirFile = new File(baseDir);
                if (!baseDirFile.exists() && !baseDirFile.mkdirs()) {
                    logger.error(Intrinsics.stringPlus("Failed to create formulas directory ", baseDirFile));
                }
                string2 = smt2file;
            }
            return string2;
        }

        public static /* synthetic */ String getFilePathForSmtQuery$default(Companion companion, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            return companion.getFilePathForSmtQuery(string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArtifactLocation.values().length];
            nArray[ArtifactLocation.CWD.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

