/*
 * Decompiled with CFR 0.152.
 */
package log;

import config.Config;
import java.io.OutputStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import log.ArtifactManagerFactory;
import log.ILogger;
import log.Logger;
import log.LoggerLevels;
import log.LoggerTypes;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.OutPrinter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J \u0010\u0014\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0015J\u001e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u001a\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u001a\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J(\u0010\u001c\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010\u001e\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u001e\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Llog/Logger;", "Llog/ILogger;", "type", "Llog/LoggerTypes;", "(Llog/LoggerTypes;)V", "consoleLogExceptions", "", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "getType", "()Llog/LoggerTypes;", "debug", "", "msg", "Lkotlin/Function0;", "", "t", "", "error", "", "s", "formatMessage", "level", "Llog/LoggerLevels;", "info", "isEnabled", "outPrintLog", "trace", "warn", "Companion", "Shared"})
public final class Logger
implements ILogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoggerTypes type;
    private final boolean consoleLogExceptions;
    @NotNull
    private final KLogger logger;
    @NotNull
    private static final String slf4jPrefix = "org.slf4j.simpleLogger.log.";
    @NotNull
    private static final Logger underlyingLogger = new Logger(LoggerTypes.ALWAYS);
    @NotNull
    private static final Lazy<OutputStreamWriter> regressionFile$delegate = LazyKt.lazy(Companion.regressionFile.2.INSTANCE);

    public Logger(@NotNull LoggerTypes type) {
        String levelString;
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.type = type;
        String levelProp = this.type.toLevelProp();
        String level = System.getProperty(levelProp);
        String verboseProp = this.type.toVerboseProp();
        String string2 = level != null ? level : (levelString = System.getProperty(verboseProp) != null ? LoggerLevels.DEBUG.name() : (String)null);
        if (levelString != null) {
            System.setProperty(Intrinsics.stringPlus(slf4jPrefix, (Object)this.type), levelString);
            if (System.getProperty(this.type.toTopicProp()) == null) {
                System.setProperty(this.type.toTopicProp(), "1");
            }
        }
        this.consoleLogExceptions = System.getenv("CERTORA_DEV_MODE") != null;
        this.logger = KotlinLogging.INSTANCE.logger(this.type.toString());
    }

    @NotNull
    public final LoggerTypes getType() {
        return this.type;
    }

    @Override
    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isEnabled() {
        return Config.INSTANCE.isEnabledLogger(this.type);
    }

    private final String formatMessage(LoggerLevels level, Function0<? extends Object> msg) {
        return '[' + Thread.currentThread().getName() + "] " + level.name() + ' ' + (Object)((Object)this.type) + " - " + msg.invoke();
    }

    private final void outPrintLog(Throwable t2, Function0<? extends Object> msg, LoggerLevels level) {
        OutPrinter.INSTANCE.printInfo(this.formatMessage(level, msg));
        if (t2 != null) {
            OutPrinter.INSTANCE.printStacktrace(t2);
        }
    }

    @Override
    public void error(@Nullable Throwable t2, @NotNull Function0<? extends Object> msg) {
        boolean bl;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.outPrintLog(t2, msg, LoggerLevels.ERROR);
        KLogger kLogger = this.getLogger();
        Throwable throwable = t2;
        if (throwable == null) {
            object2 = null;
        } else {
            object = throwable;
            boolean bl2 = false;
            bl = false;
            Throwable throwable2 = object;
            KLogger kLogger2 = kLogger;
            boolean bl3 = false;
            boolean bl4 = this.consoleLogExceptions;
            kLogger = kLogger2;
            object2 = bl4 ? object : null;
        }
        kLogger.error((Throwable)object2, msg);
        Companion.regression(msg, false);
        throwable = t2;
        if (throwable != null && (object = throwable.getMessage()) != null) {
            Object object3 = object;
            bl = false;
            boolean bl5 = false;
            Object it = object3;
            boolean bl6 = false;
            Companion.regression((Function0<? extends Object>)new Function0<Object>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
        }
    }

    public final void error(@Nullable Throwable t2, @NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        this.error(t2, (Function0<? extends Object>)new Function0<Object>(s){
            final /* synthetic */ String $s;
            {
                this.$s = $s;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return this.$s;
            }
        });
    }

    @Override
    public void error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.error(null, (Function0<? extends Object>)new Function0<Object>(msg){
            final /* synthetic */ String $msg;
            {
                this.$msg = $msg;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return this.$msg;
            }
        });
    }

    @Override
    public void warn(@Nullable Throwable t2, @NotNull Function0<? extends Object> msg) {
        boolean bl;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.outPrintLog(t2, msg, LoggerLevels.WARN);
        KLogger kLogger = this.getLogger();
        Throwable throwable = t2;
        if (throwable == null) {
            object2 = null;
        } else {
            object = throwable;
            boolean bl2 = false;
            bl = false;
            Throwable throwable2 = object;
            KLogger kLogger2 = kLogger;
            boolean bl3 = false;
            boolean bl4 = this.consoleLogExceptions;
            kLogger = kLogger2;
            object2 = bl4 ? object : null;
        }
        kLogger.warn((Throwable)object2, msg);
        Companion.regression(msg, false);
        throwable = t2;
        if (throwable != null && (object = throwable.getMessage()) != null) {
            Object object3 = object;
            bl = false;
            boolean bl5 = false;
            Object it = object3;
            boolean bl6 = false;
            Companion.regression((Function0<? extends Object>)new Function0<Object>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
        }
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.warn(null, msg);
    }

    @Override
    public void info(@Nullable Throwable t2, @NotNull Function0<? extends Object> msg) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getLogger().isInfoEnabled()) {
            this.outPrintLog(t2, msg, LoggerLevels.INFO);
        }
        KLogger kLogger = this.getLogger();
        Throwable throwable2 = t2;
        if (throwable2 == null) {
            throwable = null;
        } else {
            Throwable throwable3 = throwable2;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable4 = throwable3;
            KLogger kLogger2 = kLogger;
            boolean bl3 = false;
            boolean bl4 = this.consoleLogExceptions;
            kLogger = kLogger2;
            throwable = bl4 ? throwable3 : null;
        }
        kLogger.info(throwable, msg);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.info(null, msg);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.debug(null, msg);
    }

    @Override
    public void debug(@Nullable Throwable t2, @NotNull Function0<? extends Object> msg) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getLogger().isDebugEnabled()) {
            this.outPrintLog(null, msg, LoggerLevels.DEBUG);
        }
        KLogger kLogger = this.getLogger();
        Throwable throwable2 = t2;
        if (throwable2 == null) {
            throwable = null;
        } else {
            Throwable throwable3 = throwable2;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable4 = throwable3;
            KLogger kLogger2 = kLogger;
            boolean bl3 = false;
            boolean bl4 = this.consoleLogExceptions;
            kLogger = kLogger2;
            throwable = bl4 ? throwable3 : null;
        }
        kLogger.debug(throwable, msg);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getLogger().isTraceEnabled()) {
            this.outPrintLog(null, msg, LoggerLevels.TRACE);
        }
        this.getLogger().trace(msg);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> msg) {
        ILogger.DefaultImpls.error((ILogger)this, msg);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018J\u001c\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0011R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llog/Logger$Companion;", "", "()V", "regressionFile", "Ljava/io/OutputStreamWriter;", "getRegressionFile", "()Ljava/io/OutputStreamWriter;", "regressionFile$delegate", "Lkotlin/Lazy;", "slf4jPrefix", "", "underlyingLogger", "Llog/Logger;", "always", "", "s", "respectQuiet", "", "alwaysError", "t", "", "alwaysWarn", "regression", "str", "Lkotlin/Function0;", "toOutFile", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        private final OutputStreamWriter getRegressionFile() {
            Lazy lazy = regressionFile$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (OutputStreamWriter)lazy.getValue();
        }

        public final void always(@NotNull String s, boolean respectQuiet) {
            Intrinsics.checkNotNullParameter(s, "s");
            boolean beQuiet = respectQuiet && (Boolean)Config.INSTANCE.getQuietMode().get() != false;
            OutPrinter.INSTANCE.print(s, false, false, !beQuiet);
            underlyingLogger.info((Function0<? extends Object>)new Function0<Object>(s){
                final /* synthetic */ String $s;
                {
                    this.$s = $s;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$s;
                }
            });
        }

        public final void alwaysError(@NotNull String s) {
            Intrinsics.checkNotNullParameter(s, "s");
            this.alwaysError(s, null);
        }

        public final void alwaysError(@NotNull String s, @Nullable Throwable t2) {
            Intrinsics.checkNotNullParameter(s, "s");
            OutPrinter.INSTANCE.printErrorToScreen(s);
            underlyingLogger.error(t2, s);
        }

        public final void alwaysWarn(@NotNull String s, @Nullable Throwable t2) {
            Intrinsics.checkNotNullParameter(s, "s");
            OutPrinter.INSTANCE.printWarningToScreen(s);
            underlyingLogger.warn(t2, (Function0<? extends Object>)new Function0<Object>(s){
                final /* synthetic */ String $s;
                {
                    this.$s = $s;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$s;
                }
            });
        }

        public final void alwaysWarn(@NotNull String s) {
            Intrinsics.checkNotNullParameter(s, "s");
            this.alwaysWarn(s, null);
        }

        public final void regression(@NotNull Function0<? extends Object> str2) {
            Intrinsics.checkNotNullParameter(str2, "str");
            this.regression(str2, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void regression(@NotNull Function0<? extends Object> str2, boolean toOutFile) {
            Intrinsics.checkNotNullParameter(str2, "str");
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                if (toOutFile) {
                    OutPrinter.INSTANCE.print(str2.invoke().toString(), false, false, false);
                }
                if (((Boolean)Config.INSTANCE.getRegressionTest().get()).booleanValue() && ArtifactManagerFactory.INSTANCE.isEnabled()) {
                    Appendable appendable;
                    OutputStreamWriter outputStreamWriter = Companion.getRegressionFile();
                    if (outputStreamWriter == null) {
                        appendable = null;
                    } else {
                        Appendable appendable2 = outputStreamWriter;
                        CharSequence charSequence = str2.invoke().toString();
                        boolean bl4 = false;
                        Appendable appendable3 = appendable2.append(charSequence);
                        Intrinsics.checkNotNullExpressionValue(appendable3, "append(value)");
                        Appendable appendable4 = appendable3;
                        boolean bl5 = false;
                        Appendable appendable5 = appendable4.append('\n');
                        appendable = appendable5;
                        Intrinsics.checkNotNullExpressionValue(appendable5, "append('\\n')");
                    }
                    outputStreamWriter = Companion.getRegressionFile();
                    if (outputStreamWriter != null) {
                        outputStreamWriter.flush();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

