/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.interval;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math3.stat.interval.ConfidenceInterval;
import org.apache.commons.math3.stat.interval.IntervalUtils;
import org.apache.commons.math3.util.FastMath;

public class NormalApproximationInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double mean2 = (double)numberOfSuccesses / (double)numberOfTrials;
        double alpha = (1.0 - confidenceLevel) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution();
        double difference = normalDistribution.inverseCumulativeProbability(1.0 - alpha) * FastMath.sqrt(1.0 / (double)numberOfTrials * mean2 * (1.0 - mean2));
        return new ConfidenceInterval(mean2 - difference, mean2 + difference, confidenceLevel);
    }
}

