/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CollectionUtils {
    public static Map mergeMaps(Map dominantMap, Map recessiveMap) {
        if (dominantMap == null && recessiveMap == null) {
            return null;
        }
        if (dominantMap != null && recessiveMap == null) {
            return dominantMap;
        }
        if (dominantMap == null && recessiveMap != null) {
            return recessiveMap;
        }
        HashMap result2 = new HashMap();
        Set dominantMapKeys = dominantMap.keySet();
        Set recessiveMapKeys = recessiveMap.keySet();
        Collection contributingRecessiveKeys = CollectionUtils.subtract(recessiveMapKeys, CollectionUtils.intersection(dominantMapKeys, recessiveMapKeys));
        result2.putAll(dominantMap);
        Iterator i = contributingRecessiveKeys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            result2.put(key, recessiveMap.get(key));
        }
        return result2;
    }

    public static Map mergeMaps(Map[] maps) {
        Map result2 = null;
        if (maps.length == 0) {
            result2 = null;
        } else if (maps.length == 1) {
            result2 = maps[0];
        } else {
            result2 = CollectionUtils.mergeMaps(maps[0], maps[1]);
            for (int i = 2; i < maps.length; ++i) {
                result2 = CollectionUtils.mergeMaps(result2, maps[i]);
            }
        }
        return result2;
    }

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list2 = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list2.add(obj);
            }
        }
        return list2;
    }

    public static Collection subtract(Collection a, Collection b) {
        ArrayList list2 = new ArrayList(a);
        Iterator it = b.iterator();
        while (it.hasNext()) {
            list2.remove(it.next());
        }
        return list2;
    }

    public static Map getCardinalityMap(Collection col) {
        HashMap count2 = new HashMap();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Integer c = (Integer)count2.get(obj);
            if (null == c) {
                count2.put(obj, new Integer(1));
                continue;
            }
            count2.put(obj, new Integer(c + 1));
        }
        return count2;
    }

    public static List iteratorToList(Iterator it) {
        if (it == null) {
            throw new NullPointerException("it cannot be null.");
        }
        ArrayList list2 = new ArrayList();
        while (it.hasNext()) {
            list2.add(it.next());
        }
        return list2;
    }

    private static final int getFreq(Object obj, Map freqMap) {
        try {
            Object o = freqMap.get(obj);
            if (o != null) {
                return (Integer)o;
            }
        }
        catch (NullPointerException e) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 0;
    }
}

