/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;
import solver.SolverInfoClOptions;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lsolver/AltErgoSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_ALT_ERGO_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getProcessTimeoutString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "ClOptions", "GeneralUtils"})
public final class AltErgoSolverInfo
extends SolverInfo {
    @NotNull
    public static final AltErgoSolverInfo INSTANCE = new AltErgoSolverInfo();
    @NotNull
    private static final String DEFAULT_ALT_ERGO_COMMAND = "alt-ergo";

    private AltErgoSolverInfo() {
        super("Alt-Ergo");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--timelimit=", timeout.toSeconds()));
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--timelimit=", timeout.toSeconds()));
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        List<String> list2;
        String string2;
        boolean bl = !incrementalMode;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            throw new UnsupportedOperationException("support of incremental mode by Alt-Ergo (in SMT-mode) is unclear (might investigate)");
        }
        Collection collection = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)RuntimeEnvInfo.INSTANCE.getTimeoutCommandIfAvailable(timeout), (Iterable)CollectionsKt.listOf((string2 = customSolverExecutable) == null ? DEFAULT_ALT_ERGO_COMMAND : string2)), (Iterable)CollectionsKt.listOf("--input=smtlib2"));
        if (timeout != null) {
            list2 = this.getQueryTimeoutString(timeout);
        } else {
            boolean bl5 = false;
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_ALT_ERGO_COMMAND;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lsolver/AltErgoSolverInfo$ClOptions;", "", "Lsolver/SolverInfoClOptions;", "(Ljava/lang/String;I)V", "solverInfo", "Lsolver/AltErgoSolverInfo;", "getSolverInfo", "()Lsolver/AltErgoSolverInfo;", "Default", "GeneralUtils"})
    public static final abstract class ClOptions
    extends Enum<ClOptions>
    implements SolverInfoClOptions {
        @NotNull
        private final AltErgoSolverInfo solverInfo = INSTANCE;
        public static final /* enum */ ClOptions Default = new Default("Default", 0);
        private static final /* synthetic */ ClOptions[] $VALUES;

        private ClOptions() {
        }

        @Override
        @NotNull
        public AltErgoSolverInfo getSolverInfo() {
            return this.solverInfo;
        }

        public static ClOptions[] values() {
            return (ClOptions[])$VALUES.clone();
        }

        public static ClOptions valueOf(String value) {
            return Enum.valueOf(ClOptions.class, value);
        }

        public /* synthetic */ ClOptions(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = clOptionsArray = new ClOptions[]{ClOptions.Default};
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/AltErgoSolverInfo$ClOptions$Default;", "Lsolver/AltErgoSolverInfo$ClOptions;", "clName", "", "getClName", "()Ljava/lang/String;", "clOptions", "", "getClOptions", "()Ljava/util/List;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Default
        extends ClOptions {
            @NotNull
            private final String clName;
            @NotNull
            private final List<String> clOptions;

            /*
             * WARNING - void declaration
             */
            Default() {
                void var1_1;
                this.clName = "altergo_def";
                boolean bl = false;
                this.clOptions = CollectionsKt.emptyList();
            }

            @Override
            @NotNull
            public String getClName() {
                return this.clName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }
    }
}

