/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import log.CvtLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfoClOptions;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\rH&J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0006\u0010\u0018\u001a\u00020\rJ\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH&J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006 "}, d2={"Lsolver/SolverInfo;", "Ljava/io/Serializable;", "name", "", "(Ljava/lang/String;)V", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "defaultCommandVersionInfo", "getDefaultCommandVersionInfo", "defaultCommandVersionInfo$delegate", "Lkotlin/Lazy;", "isDefaultCommandAvailable", "", "()Z", "getName", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "getProcessTimeoutString", "getQueryTimeoutString", "isAvailable", "preprocessCheckSatOutput", "lines", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "toString", "Companion", "GeneralUtils"})
public abstract class SolverInfo
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Lazy defaultCommandVersionInfo$delegate;
    private final boolean isDefaultCommandAvailable;
    @NotNull
    private static final CvtLogger logger;

    public SolverInfo(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.defaultCommandVersionInfo$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ SolverInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return RuntimeEnvInfo.getSolverVersionIfAvailable$default(RuntimeEnvInfo.INSTANCE, this.this$0, null, 2, null);
            }
        });
        this.isDefaultCommandAvailable = this.getDefaultCommandVersionInfo() != null;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public abstract String getDefaultCommand();

    private final String getDefaultCommandVersionInfo() {
        Lazy lazy = this.defaultCommandVersionInfo$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public final boolean isAvailable() {
        return this.getDefaultCommandVersionInfo() != null;
    }

    public final boolean isDefaultCommandAvailable() {
        return this.isDefaultCommandAvailable;
    }

    @NotNull
    public abstract List<String> getProcessTimeoutString(@NotNull Duration var1);

    @NotNull
    public abstract List<String> getQueryTimeoutString(@NotNull Duration var1);

    public abstract boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures var1);

    @NotNull
    public abstract List<String> commandForStdInMode(@Nullable String var1, @Nullable Duration var2, boolean var3);

    public static /* synthetic */ List commandForStdInMode$default(SolverInfo solverInfo, String string2, Duration duration, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: commandForStdInMode");
        }
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return solverInfo.commandForStdInMode(string2, duration, bl);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public List<String> preprocessCheckSatOutput(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        return lines;
    }

    static {
        String[] stringArray = new String[]{"smtlibutils", "solverInfo"};
        logger = new CvtLogger(stringArray, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J7\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015JA\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0017\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lsolver/SolverInfo$Companion;", "", "()V", "logger", "Llog/CvtLogger;", "getLogger", "()Llog/CvtLogger;", "getConfig", "Lsolver/SolverConfig;", "cl", "Lsolver/SolverInfoClOptions;", "timeout", "Ljava/time/Duration;", "memlimitBytes", "", "incrementalMode", "", "(Lsolver/SolverInfoClOptions;Ljava/time/Duration;Ljava/lang/Long;Z)Lsolver/SolverConfig;", "getConfigIfQualifies", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Lsolver/SolverInfoClOptions;Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Lsolver/SolverConfig;", "getDefaultConfigs", "", "allowedClOptions", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;Ljava/util/List;)Ljava/util/List;", "GeneralUtils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CvtLogger getLogger() {
            return logger;
        }

        @NotNull
        public final SolverConfig getConfig(@NotNull SolverInfoClOptions cl, @NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
            Intrinsics.checkNotNullParameter(cl, "cl");
            Intrinsics.checkNotNullParameter(timeout, "timeout");
            return new SolverConfig(cl.getSolverInfo(), timeout, memlimitBytes, incrementalMode, cl.getClOptions(), null, null, null, 224, null);
        }

        @Nullable
        public final SolverConfig getConfigIfQualifies(@NotNull SolverInfoClOptions cl, @NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
            Intrinsics.checkNotNullParameter(cl, "cl");
            Intrinsics.checkNotNullParameter(timeout, "timeout");
            Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
            return cl.qualifiesFor(logicFeatures) ? this.getConfig(cl, timeout, memlimitBytes, incrementalMode) : (SolverConfig)null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures, @NotNull List<? extends SolverInfoClOptions> allowedClOptions) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SolverInfoClOptions it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(timeout, "timeout");
            Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
            Intrinsics.checkNotNullParameter(allowedClOptions, "allowedClOptions");
            Collection collection = allowedClOptions;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string2 = "disallowed all SolverClOptions, yet asking for some";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Iterable $this$filter$iv = allowedClOptions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SolverInfoClOptions)element$iv$iv;
                boolean bl5 = false;
                if (!it.qualifiesFor(logicFeatures)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SolverInfoClOptions)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl6 = false;
                SolverConfig solverConfig = Companion.getConfig(it, timeout, memlimitBytes, incrementalMode);
                collection2.add(solverConfig);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

