/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.CVLErrorLogger;
import spec.StandardCVLErrorLogger;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSingleRule;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.HasCVLErrorLogger;
import spec.cvlast.MethodIdWithCallContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lspec/cvlast/CVLStructChecker;", "Lspec/cvlast/HasCVLErrorLogger;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "errorLogger", "Lspec/CVLErrorLogger;", "(Lspec/cvlast/CVLSymbolTable;Lspec/CVLErrorLogger;)V", "getErrorLogger", "()Lspec/CVLErrorLogger;", "checkLastStatementIsAssert", "", "rule", "Lspec/cvlast/CVLSingleRule;", "checkLastStatementIsAssertRec", "last", "Lspec/cvlast/CVLCmd;", "Shared"})
public final class CVLStructChecker
implements HasCVLErrorLogger {
    @NotNull
    private final CVLSymbolTable symbolTable;
    @NotNull
    private final CVLErrorLogger errorLogger;

    public CVLStructChecker(@NotNull CVLSymbolTable symbolTable, @NotNull CVLErrorLogger errorLogger) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(errorLogger, "errorLogger");
        this.symbolTable = symbolTable;
        this.errorLogger = errorLogger;
    }

    public /* synthetic */ CVLStructChecker(CVLSymbolTable cVLSymbolTable, CVLErrorLogger cVLErrorLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cVLErrorLogger = StandardCVLErrorLogger.INSTANCE;
        }
        this(cVLSymbolTable, cVLErrorLogger);
    }

    @Override
    @NotNull
    public CVLErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLastStatementIsAssertRec(CVLCmd last2, CVLSingleRule rule) {
        CVLCmd cVLCmd = last2;
        if (cVLCmd instanceof CVLCmd.Simple) {
            if (last2 instanceof CVLCmd.Simple.Apply) {
                Unit unit;
                Unit unit2;
                CVLExp.ApplyExp.CVLFunction cVLFunction;
                CVLExp.ApplyExp applyExp = ((CVLCmd.Simple.Apply)last2).getExp();
                CVLExp.ApplyExp.CVLFunction cVLFunction2 = cVLFunction = applyExp instanceof CVLExp.ApplyExp.CVLFunction ? (CVLExp.ApplyExp.CVLFunction)applyExp : null;
                if (cVLFunction == null) {
                    unit2 = null;
                } else {
                    applyExp = cVLFunction;
                    boolean bl = false;
                    boolean bl2 = false;
                    CVLExp.ApplyExp it = applyExp;
                    boolean bl3 = false;
                    MethodIdWithCallContext methodIdWithCallContext = ((CVLExp.ApplyExp.CVLFunction)it).getMethodIdWithCallContext();
                    CVLScope cVLScope = ((CVLExp.ApplyExp.CVLFunction)it).getTag().getCVLScope();
                    Intrinsics.checkNotNull(cVLScope);
                    CVLSymbolTable.SymbolInfo subInfo = this.symbolTable.lookUpWithMethodIdWithCallContext(methodIdWithCallContext, cVLScope);
                    boolean bl4 = subInfo != null && subInfo.getHook() instanceof CVLFunction;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (!bl4) {
                        boolean bl7 = false;
                        String string2 = " type checking should ensure a subroutine apply refers to a symbol registered in the symbol table as a subroutine";
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    CVLFunction cvlFunc = (CVLFunction)subInfo.getHook();
                    this.checkLastStatementIsAssertRec(new CVLCmd.Composite.Block(cvlFunc.getLoc(), cvlFunc.getBlock(), null, 4, null), rule);
                    unit2 = unit = Unit.INSTANCE;
                }
                if (unit == null) {
                    this.syntaxError(last2.getLoc(), "last statement of the rule " + rule.getDeclarationId() + " in " + rule.getLoc() + " is not an assert command (but must be)");
                }
            } else if (!(last2 instanceof CVLCmd.Simple.Assert)) {
                this.syntaxError(last2.getLoc(), "last statement of the rule " + rule.getDeclarationId() + " in " + rule.getLoc() + " is not an assert command (but must be)");
            }
        } else if (cVLCmd instanceof CVLCmd.Composite) {
            CVLCmd.Composite composite = (CVLCmd.Composite)last2;
            if (composite instanceof CVLCmd.Composite.If) {
                this.checkLastStatementIsAssertRec(((CVLCmd.Composite.If)last2).getElseCmd(), rule);
                this.checkLastStatementIsAssertRec(((CVLCmd.Composite.If)last2).getThenCmd(), rule);
            } else if (composite instanceof CVLCmd.Composite.Block) {
                Object v4;
                CVLStructChecker cVLStructChecker;
                block15: {
                    void $this$lastOrNull$iv;
                    List<CVLCmd> list2 = ((CVLCmd.Composite.Block)last2).getBlock();
                    cVLStructChecker = this;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        CVLCmd it = (CVLCmd)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof CVLCmd.Simple.Label))) continue;
                        v4 = element$iv;
                        break block15;
                    }
                    v4 = null;
                }
                Object var17_27 = v4;
                CVLCmd cVLCmd2 = var17_27;
                if (cVLCmd2 == null) {
                    throw new IllegalStateException(Intrinsics.stringPlus("Got an empty CVL block in ", last2.getLoc()));
                }
                cVLStructChecker.checkLastStatementIsAssertRec(cVLCmd2, rule);
            }
        }
    }

    public final void checkLastStatementIsAssert(@NotNull CVLSingleRule rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        this.checkLastStatementIsAssertRec(new CVLCmd.Composite.Block(rule.getLoc(), rule.getBlock(), null, 4, null), rule);
    }

    @Override
    public void syntaxError(@NotNull CVLLocation loc, @NotNull String message) {
        HasCVLErrorLogger.DefaultImpls.syntaxError(this, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc) {
        return HasCVLErrorLogger.DefaultImpls.typeError(this, exp, loc);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, exp, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLLhs lhs, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, lhs, loc, message);
    }
}

