/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\bJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\bJ\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\bJ\u0012\u0010!\u001a\n \"*\u0004\u0018\u00010\b0\b*\u00020\bJ\f\u0010#\u001a\u00020\b*\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lutils/ArtifactFileUtils;", "", "()V", "MAX_FILE_NAME_LENGTH", "", "conversion", "", "Lkotlin/Pair;", "", "ensureFolderExists", "", "dirString", "getBasenameOnly", "fileName", "getCertoraDir", "getFilesWithExtension", "path", "ext", "getNameFromPath", "name", "getRelativeFileName", "wholePath", "newRootDir", "getResultFile", "getWriterForFile", "Ljava/io/FileWriter;", "filePath", "overwrite", "", "append", "hasCertoraDir", "isSol", "isTAC", "asUnixPath", "kotlin.jvm.PlatformType", "normalizeEncodedStringToStringWithABIChars", "GeneralUtils"})
public final class ArtifactFileUtils {
    @NotNull
    public static final ArtifactFileUtils INSTANCE = new ArtifactFileUtils();
    @NotNull
    private static final List<Pair<String, String>> conversion;
    public static final int MAX_FILE_NAME_LENGTH = 255;

    private ArtifactFileUtils() {
    }

    public final String asUnixPath(@NotNull String $this$asUnixPath) {
        Intrinsics.checkNotNullParameter($this$asUnixPath, "<this>");
        return FilenameUtils.separatorsToUnix($this$asUnixPath);
    }

    public final boolean hasCertoraDir() {
        return System.getenv().containsKey("CERTORA");
    }

    @NotNull
    public final String getCertoraDir() {
        String string2 = System.getenv("CERTORA");
        Intrinsics.checkNotNullExpressionValue(string2, "getenv(\"CERTORA\")");
        return string2;
    }

    @NotNull
    public final String getNameFromPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = FileUtils.filename(name);
        Intrinsics.checkNotNullExpressionValue(string2, "filename(name)");
        return string2;
    }

    @NotNull
    public final String getResultFile() {
        return "Results.txt";
    }

    public final void ensureFolderExists(@NotNull String dirString) {
        boolean success;
        Intrinsics.checkNotNullParameter(dirString, "dirString");
        File dir = new File(dirString);
        if (!(dir.exists() || (success = dir.mkdirs()) || dir.exists())) {
            throw new Exception(Intrinsics.stringPlus("Failed to create directory ", dirString));
        }
    }

    @NotNull
    public final String getRelativeFileName(@NotNull String wholePath, @NotNull String newRootDir) {
        Intrinsics.checkNotNullParameter(wholePath, "wholePath");
        Intrinsics.checkNotNullParameter(newRootDir, "newRootDir");
        if (!StringsKt.contains$default((CharSequence)wholePath, newRootDir, false, 2, null)) {
            throw new Exception("Could not find " + newRootDir + " in " + wholePath);
        }
        int cfgDirPathIdx = 0;
        Path path = FileSystems.getDefault().getPath(wholePath, new String[0]);
        Iterator<Path> iterator2 = path.iterator();
        boolean bl = false;
        boolean bl2 = false;
        Iterator<Path> $this$getRelativeFileName_u24lambda_u2d1 = iterator2;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue($this$getRelativeFileName_u24lambda_u2d1, "");
        Iterator<Path> $this$forEach$iv = $this$getRelativeFileName_u24lambda_u2d1;
        boolean $i$f$forEach = false;
        Iterator<Path> iterator3 = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Path> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            Path element$iv;
            Path it = element$iv = iterator4.next();
            boolean bl5 = false;
            if (Intrinsics.areEqual(((Object)it).toString(), newRootDir)) break;
            ++cfgDirPathIdx;
        }
        return ((Object)path.subpath(cfgDirPathIdx, path.getNameCount())).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFilesWithExtension(@NotNull String path, @NotNull String ext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(ext, "ext");
        String[] lsResult = new File(path).list();
        Intrinsics.checkNotNullExpressionValue(lsResult, "lsResult");
        String[] $this$filter$iv = lsResult;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_9 = $this$filterTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void fileName = element$iv$iv = var10_9[i];
            boolean bl = false;
            if (!ext.equals(FileUtils.extension((String)fileName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantResults = (List)destination$iv$iv;
        ArtifactFileUtilsKt.access$getLogger$p().info("For path " + path + " ls result is " + ArraysKt.asList(lsResult) + " and files matching extension " + ext + " are " + relevantResults);
        return relevantResults;
    }

    public final boolean isTAC(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string2 = FileUtils.extension(fileName);
        Intrinsics.checkNotNullExpressionValue(string2, "extension(fileName)");
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        return Intrinsics.areEqual(string3, "tac");
    }

    public final boolean isSol(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string2 = FileUtils.extension(fileName);
        Intrinsics.checkNotNullExpressionValue(string2, "extension(fileName)");
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        return Intrinsics.areEqual(string3, "sol");
    }

    @NotNull
    public final String getBasenameOnly(@NotNull String fileName) {
        String string2;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String separators = "/|\\\\";
        CharSequence charSequence = fileName;
        Regex regex = new Regex(separators);
        int n = 0;
        boolean bl = false;
        charSequence = CollectionsKt.last(regex.split(charSequence, n));
        boolean bl2 = false;
        n = 0;
        String filename = (String)charSequence;
        boolean bl3 = false;
        String basename = FileUtils.basename(filename);
        Intrinsics.checkNotNullExpressionValue(basename, "basename");
        if (StringsKt.last(basename) == '.') {
            String string3 = basename;
            int n2 = 0;
            int n3 = basename.length() - 1;
            boolean bl4 = false;
            String string4 = string3.substring(n2, n3);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = basename;
        }
        String string5 = string2;
        Intrinsics.checkNotNullExpressionValue(string5, "fileName.split(Regex(sep\u2026          }\n            }");
        return string5;
    }

    @NotNull
    public final FileWriter getWriterForFile(@NotNull String filePath, boolean overwrite, boolean append) {
        String string2;
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        String string3 = FileUtils.dirname(filePath);
        boolean bl = false;
        boolean bl2 = false;
        String dir = string3;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue(dir, "dir");
        CharSequence charSequence = dir;
        boolean bl4 = false;
        String dirPart = !StringsKt.isBlank(charSequence) ? Intrinsics.stringPlus(dir, File.separator) : "";
        String fileExtension = FileUtils.extension(filePath);
        String sanitizedFileBaseName = ArtifactFileUtils.getWriterForFile$sanitizeFileBaseName(this.getBasenameOnly(filePath), fileExtension.length() + 1);
        Intrinsics.checkNotNullExpressionValue(fileExtension, "fileExtension");
        String sanitizedFileName = ArtifactFileUtils.getWriterForFile$appendExtension(sanitizedFileBaseName, fileExtension);
        String sanitizedFilePath = Intrinsics.stringPlus(dirPart, sanitizedFileName);
        if (new File(sanitizedFilePath).exists() && !overwrite) {
            String string4 = LocalDateTime.now().toString();
            Intrinsics.checkNotNullExpressionValue(string4, "now().toString()");
            String uniqueSuffix = Intrinsics.stringPlus("_", StringsKt.replace$default(string4, ':', '-', false, 4, null));
            if (sanitizedFileBaseName.length() + uniqueSuffix.length() + 1 + fileExtension.length() > 255) {
                boolean bl5 = sanitizedFileBaseName.length() - uniqueSuffix.length() > 1;
                int n = 0;
                int n2 = 0;
                if (!bl5) {
                    boolean bl6 = false;
                    String string5 = "length of sanitized file name (" + sanitizedFileBaseName + ") minus length of uniqueSuffix (" + uniqueSuffix + ") is negative, even though the expected file length exceeds the maximum allowed file name length (255) --> unexpected ";
                    throw (Throwable)new IllegalStateException(string5.toString());
                }
                String string6 = sanitizedFileBaseName;
                n = 0;
                n2 = sanitizedFileBaseName.length() - uniqueSuffix.length();
                boolean bl7 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = Intrinsics.stringPlus(string8, uniqueSuffix);
            } else {
                string2 = Intrinsics.stringPlus(sanitizedFileBaseName, uniqueSuffix);
            }
        } else {
            string2 = sanitizedFileBaseName;
        }
        String nonConflictingFileBaseName = string2;
        String actualFileName = Intrinsics.stringPlus(dirPart, ArtifactFileUtils.getWriterForFile$appendExtension(nonConflictingFileBaseName, fileExtension));
        return new FileWriter(actualFileName, append);
    }

    public static /* synthetic */ FileWriter getWriterForFile$default(ArtifactFileUtils artifactFileUtils, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return artifactFileUtils.getWriterForFile(string2, bl, bl2);
    }

    @Deprecated(message="Never use this function. DO NOT reintroduce any translation back to strings with ABI chars", level=DeprecationLevel.ERROR)
    @NotNull
    public final String normalizeEncodedStringToStringWithABIChars(@NotNull String $this$normalizeEncodedStringToStringWithABIChars) {
        Intrinsics.checkNotNullParameter($this$normalizeEncodedStringToStringWithABIChars, "<this>");
        String filename = $this$normalizeEncodedStringToStringWithABIChars;
        for (Pair<String, String> p : conversion) {
            filename = StringsKt.replace$default(filename, p.getSecond(), p.getFirst(), false, 4, null);
        }
        return filename;
    }

    private static final String getWriterForFile$sanitizeFileBaseName(String _filename, int extensionLength) {
        String string2;
        String filename = null;
        filename = _filename;
        for (Pair<String, String> p : conversion) {
            filename = StringsKt.replace$default(filename, p.getFirst(), p.getSecond(), false, 4, null);
        }
        int maxLength = 255 - extensionLength;
        boolean p = maxLength > 1;
        int n = 0;
        int n2 = 0;
        if (!p) {
            boolean bl = false;
            String string3 = "extension length (" + extensionLength + ") larger than 255 -- unexpected";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        if (filename.length() > maxLength) {
            n = filename.hashCode();
            n2 = 36;
            int n3 = 0;
            String string4 = Integer.toString(n, CharsKt.checkRadix(n2));
            Intrinsics.checkNotNullExpressionValue(string4, "java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String hash = string4;
            n = maxLength - 1 - hash.length() > 1 ? 1 : 0;
            n2 = 0;
            n3 = 0;
            if (n == 0) {
                boolean bl = false;
                String string5 = "hash (" + hash + ") is longer than a more-than-max-length file name (" + filename + ") -- unexpected";
                throw (Throwable)new IllegalStateException(string5.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string6 = filename;
            n2 = 0;
            n3 = maxLength - 1 - hash.length();
            boolean bl = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = stringBuilder.append(string8).append('_').append(hash).toString();
        } else {
            string2 = filename;
        }
        return string2;
    }

    private static final String getWriterForFile$appendExtension(String basename, String extension) {
        boolean bl = !StringsKt.contains$default((CharSequence)extension, ".", false, 2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "File name extension (" + extension + ") contains a \".\".";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        CharSequence charSequence = extension;
        bl2 = false;
        return charSequence.length() == 0 ? basename : basename + '.' + extension;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<String, String>("(", "LP"), new Pair<String, String>(")", "RP"), new Pair<String, String>(",", "C"), new Pair<String, String>("[", "LB"), new Pair<String, String>("]", "RB"), new Pair<String, String>("[]", "LBRB"), new Pair<String, String>("uint256", "U256"), new Pair<String, String>("address", "ADR"), new Pair<String, String>("bytes32", "B32")};
        conversion = CollectionsKt.listOf(pairArray);
    }
}

