"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from apideck_unify.agedcreditors_sdk import AgedCreditorsSDK
from apideck_unify.ageddebtors_sdk import AgedDebtorsSDK
from apideck_unify.attachments import Attachments
from apideck_unify.balancesheet_sdk import BalanceSheetSDK
from apideck_unify.bankaccounts import BankAccounts
from apideck_unify.bankfeedaccounts import BankFeedAccounts
from apideck_unify.bankfeedstatements import BankFeedStatements
from apideck_unify.billpayments import BillPayments
from apideck_unify.bills import Bills
from apideck_unify.categories import Categories
from apideck_unify.companyinfo_sdk import CompanyInfoSDK
from apideck_unify.creditnotes import CreditNotes
from apideck_unify.customers import Customers
from apideck_unify.departments import Departments
from apideck_unify.expenses import Expenses
from apideck_unify.invoiceitems import InvoiceItems
from apideck_unify.invoices import Invoices
from apideck_unify.journalentries import JournalEntries
from apideck_unify.ledgeraccounts import LedgerAccounts
from apideck_unify.locations import Locations
from apideck_unify.payments import Payments
from apideck_unify.profitandloss_sdk import ProfitAndLossSDK
from apideck_unify.projects import Projects
from apideck_unify.purchaseorders import PurchaseOrders
from apideck_unify.quotes import Quotes
from apideck_unify.subsidiaries import Subsidiaries
from apideck_unify.suppliers import Suppliers
from apideck_unify.taxrates import TaxRates
from apideck_unify.trackingcategories import TrackingCategories
from typing import Optional


class Accounting(BaseSDK):
    tax_rates: TaxRates
    bills: Bills
    invoices: Invoices
    ledger_accounts: LedgerAccounts
    invoice_items: InvoiceItems
    credit_notes: CreditNotes
    customers: Customers
    suppliers: Suppliers
    payments: Payments
    company_info: CompanyInfoSDK
    balance_sheet: BalanceSheetSDK
    profit_and_loss: ProfitAndLossSDK
    journal_entries: JournalEntries
    purchase_orders: PurchaseOrders
    subsidiaries: Subsidiaries
    locations: Locations
    departments: Departments
    attachments: Attachments
    bank_accounts: BankAccounts
    tracking_categories: TrackingCategories
    bill_payments: BillPayments
    expenses: Expenses
    aged_creditors: AgedCreditorsSDK
    aged_debtors: AgedDebtorsSDK
    bank_feed_accounts: BankFeedAccounts
    bank_feed_statements: BankFeedStatements
    categories: Categories
    quotes: Quotes
    projects: Projects

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.tax_rates = TaxRates(self.sdk_configuration, parent_ref=self.parent_ref)
        self.bills = Bills(self.sdk_configuration, parent_ref=self.parent_ref)
        self.invoices = Invoices(self.sdk_configuration, parent_ref=self.parent_ref)
        self.ledger_accounts = LedgerAccounts(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.invoice_items = InvoiceItems(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.credit_notes = CreditNotes(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.customers = Customers(self.sdk_configuration, parent_ref=self.parent_ref)
        self.suppliers = Suppliers(self.sdk_configuration, parent_ref=self.parent_ref)
        self.payments = Payments(self.sdk_configuration, parent_ref=self.parent_ref)
        self.company_info = CompanyInfoSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.balance_sheet = BalanceSheetSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.profit_and_loss = ProfitAndLossSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.journal_entries = JournalEntries(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.purchase_orders = PurchaseOrders(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.subsidiaries = Subsidiaries(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.locations = Locations(self.sdk_configuration, parent_ref=self.parent_ref)
        self.departments = Departments(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.attachments = Attachments(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.bank_accounts = BankAccounts(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.tracking_categories = TrackingCategories(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.bill_payments = BillPayments(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.expenses = Expenses(self.sdk_configuration, parent_ref=self.parent_ref)
        self.aged_creditors = AgedCreditorsSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.aged_debtors = AgedDebtorsSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.bank_feed_accounts = BankFeedAccounts(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.bank_feed_statements = BankFeedStatements(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.categories = Categories(self.sdk_configuration, parent_ref=self.parent_ref)
        self.quotes = Quotes(self.sdk_configuration, parent_ref=self.parent_ref)
        self.projects = Projects(self.sdk_configuration, parent_ref=self.parent_ref)
