"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from apideck_unify import models, utils
from apideck_unify._hooks import HookContext
from apideck_unify.types import Nullable, OptionalNullable, UNSET
from apideck_unify.utils import get_security_from_env
from apideck_unify.utils.unmarshal_json_response import unmarshal_json_response
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union


class Activities(BaseSDK):
    def list(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        filter_: Optional[
            Union[models.ActivitiesFilter, models.ActivitiesFilterTypedDict]
        ] = None,
        sort: Optional[
            Union[models.ActivitiesSort, models.ActivitiesSortTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.CrmActivitiesAllResponse]:
        r"""List activities

        List activities

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param cursor: Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.
        :param limit: Number of results to return. Minimum 1, Maximum 200, Default 20
        :param filter_: Apply filters
        :param sort: Apply sorting
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesAllRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            cursor=cursor,
            limit=limit,
            filter_=utils.get_pydantic_model(
                filter_, Optional[models.ActivitiesFilter]
            ),
            sort=utils.get_pydantic_model(sort, Optional[models.ActivitiesSort]),
            pass_through=pass_through,
            fields=fields,
        )

        req = self._build_request(
            method="GET",
            path="/crm/activities",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesAllGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesAll",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.CrmActivitiesAllResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.cursors.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                raw=raw,
                consumer_id=consumer_id,
                app_id=app_id,
                service_id=service_id,
                cursor=next_cursor,
                limit=limit,
                filter_=filter_,
                sort=sort,
                pass_through=pass_through,
                fields=fields,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesAllResponse(
                get_activities_response=unmarshal_json_response(
                    Optional[models.GetActivitiesResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesAllResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )

        raise models.APIError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        filter_: Optional[
            Union[models.ActivitiesFilter, models.ActivitiesFilterTypedDict]
        ] = None,
        sort: Optional[
            Union[models.ActivitiesSort, models.ActivitiesSortTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.CrmActivitiesAllResponse]:
        r"""List activities

        List activities

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param cursor: Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.
        :param limit: Number of results to return. Minimum 1, Maximum 200, Default 20
        :param filter_: Apply filters
        :param sort: Apply sorting
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesAllRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            cursor=cursor,
            limit=limit,
            filter_=utils.get_pydantic_model(
                filter_, Optional[models.ActivitiesFilter]
            ),
            sort=utils.get_pydantic_model(sort, Optional[models.ActivitiesSort]),
            pass_through=pass_through,
            fields=fields,
        )

        req = self._build_request_async(
            method="GET",
            path="/crm/activities",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesAllGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesAll",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.CrmActivitiesAllResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.cursors.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                raw=raw,
                consumer_id=consumer_id,
                app_id=app_id,
                service_id=service_id,
                cursor=next_cursor,
                limit=limit,
                filter_=filter_,
                sort=sort,
                pass_through=pass_through,
                fields=fields,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesAllResponse(
                get_activities_response=unmarshal_json_response(
                    Optional[models.GetActivitiesResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesAllResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )

        raise models.APIError("Unexpected response received", http_res)

    def create(
        self,
        *,
        type_: Nullable[models.ActivityType],
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        activity_datetime: OptionalNullable[str] = UNSET,
        duration_seconds: OptionalNullable[int] = UNSET,
        user_id: OptionalNullable[str] = UNSET,
        account_id: OptionalNullable[str] = UNSET,
        contact_id: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        opportunity_id: OptionalNullable[str] = UNSET,
        lead_id: OptionalNullable[str] = UNSET,
        owner_id: OptionalNullable[str] = UNSET,
        campaign_id: OptionalNullable[str] = UNSET,
        case_id: OptionalNullable[str] = UNSET,
        asset_id: OptionalNullable[str] = UNSET,
        contract_id: OptionalNullable[str] = UNSET,
        product_id: OptionalNullable[str] = UNSET,
        solution_id: OptionalNullable[str] = UNSET,
        custom_object_id: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        note: OptionalNullable[str] = UNSET,
        location: OptionalNullable[str] = UNSET,
        location_address: Optional[
            Union[models.Address, models.AddressTypedDict]
        ] = None,
        all_day_event: OptionalNullable[bool] = UNSET,
        private: OptionalNullable[bool] = UNSET,
        group_event: OptionalNullable[bool] = UNSET,
        event_sub_type: OptionalNullable[str] = UNSET,
        group_event_type: OptionalNullable[str] = UNSET,
        child: OptionalNullable[bool] = UNSET,
        archived: OptionalNullable[bool] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        show_as: OptionalNullable[models.ShowAs] = UNSET,
        done: OptionalNullable[bool] = UNSET,
        start_datetime: OptionalNullable[str] = UNSET,
        end_datetime: OptionalNullable[str] = UNSET,
        activity_date: OptionalNullable[str] = UNSET,
        end_date: OptionalNullable[str] = UNSET,
        recurrent: Optional[bool] = None,
        reminder_datetime: OptionalNullable[str] = UNSET,
        reminder_set: OptionalNullable[bool] = UNSET,
        video_conference_url: OptionalNullable[str] = UNSET,
        video_conference_id: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        attendees: Optional[
            Union[
                List[models.ActivityAttendeeInput],
                List[models.ActivityAttendeeInputTypedDict],
            ]
        ] = None,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesAddResponse:
        r"""Create activity

        Create activity

        :param type: The type of the activity
        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param activity_datetime: The date and time of the activity
        :param duration_seconds: The duration of the activity in seconds
        :param user_id: The user related to the activity
        :param account_id: The account related to the activity
        :param contact_id: The contact related to the activity
        :param company_id: The company related to the activity
        :param opportunity_id: The opportunity related to the activity
        :param lead_id: The lead related to the activity
        :param owner_id: The owner of the activity
        :param campaign_id: The campaign related to the activity
        :param case_id: The case related to the activity
        :param asset_id: The asset related to the activity
        :param contract_id: The contract related to the activity
        :param product_id: The product related to the activity
        :param solution_id: The solution related to the activity
        :param custom_object_id: The custom object related to the activity
        :param title: The title of the activity
        :param description: A description of the activity
        :param note: An internal note about the activity
        :param location: The location of the activity
        :param location_address:
        :param all_day_event: Whether the Activity is an all day event or not
        :param private: Whether the Activity is private or not
        :param group_event: Whether the Activity is a group event or not
        :param event_sub_type: The sub type of the group event
        :param group_event_type: The type of the group event
        :param child: Whether the activity is a child of another activity or not
        :param archived: Whether the activity is archived or not
        :param deleted: Whether the activity is deleted or not
        :param show_as:
        :param done: Whether the Activity is done or not
        :param start_datetime: The start date and time of the activity
        :param end_datetime: The end date and time of the activity
        :param activity_date: The date of the activity
        :param end_date: The end date of the activity
        :param recurrent: Whether the activity is recurrent or not
        :param reminder_datetime: The date and time of the reminder
        :param reminder_set: Whether the reminder is set or not
        :param video_conference_url: The URL of the video conference
        :param video_conference_id: The ID of the video conference
        :param custom_fields: Custom fields of the activity
        :param attendees:
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesAddRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            activity=models.ActivityInput(
                activity_datetime=activity_datetime,
                duration_seconds=duration_seconds,
                user_id=user_id,
                account_id=account_id,
                contact_id=contact_id,
                company_id=company_id,
                opportunity_id=opportunity_id,
                lead_id=lead_id,
                owner_id=owner_id,
                campaign_id=campaign_id,
                case_id=case_id,
                asset_id=asset_id,
                contract_id=contract_id,
                product_id=product_id,
                solution_id=solution_id,
                custom_object_id=custom_object_id,
                type=type_,
                title=title,
                description=description,
                note=note,
                location=location,
                location_address=utils.get_pydantic_model(
                    location_address, Optional[models.Address]
                ),
                all_day_event=all_day_event,
                private=private,
                group_event=group_event,
                event_sub_type=event_sub_type,
                group_event_type=group_event_type,
                child=child,
                archived=archived,
                deleted=deleted,
                show_as=show_as,
                done=done,
                start_datetime=start_datetime,
                end_datetime=end_datetime,
                activity_date=activity_date,
                end_date=end_date,
                recurrent=recurrent,
                reminder_datetime=reminder_datetime,
                reminder_set=reminder_set,
                video_conference_url=video_conference_url,
                video_conference_id=video_conference_id,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                attendees=utils.get_pydantic_model(
                    attendees, Optional[List[models.ActivityAttendeeInput]]
                ),
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/crm/activities",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesAddGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.activity, False, False, "json", models.ActivityInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesAdd",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return models.CrmActivitiesAddResponse(
                create_activity_response=unmarshal_json_response(
                    Optional[models.CreateActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesAddResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        type_: Nullable[models.ActivityType],
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        activity_datetime: OptionalNullable[str] = UNSET,
        duration_seconds: OptionalNullable[int] = UNSET,
        user_id: OptionalNullable[str] = UNSET,
        account_id: OptionalNullable[str] = UNSET,
        contact_id: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        opportunity_id: OptionalNullable[str] = UNSET,
        lead_id: OptionalNullable[str] = UNSET,
        owner_id: OptionalNullable[str] = UNSET,
        campaign_id: OptionalNullable[str] = UNSET,
        case_id: OptionalNullable[str] = UNSET,
        asset_id: OptionalNullable[str] = UNSET,
        contract_id: OptionalNullable[str] = UNSET,
        product_id: OptionalNullable[str] = UNSET,
        solution_id: OptionalNullable[str] = UNSET,
        custom_object_id: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        note: OptionalNullable[str] = UNSET,
        location: OptionalNullable[str] = UNSET,
        location_address: Optional[
            Union[models.Address, models.AddressTypedDict]
        ] = None,
        all_day_event: OptionalNullable[bool] = UNSET,
        private: OptionalNullable[bool] = UNSET,
        group_event: OptionalNullable[bool] = UNSET,
        event_sub_type: OptionalNullable[str] = UNSET,
        group_event_type: OptionalNullable[str] = UNSET,
        child: OptionalNullable[bool] = UNSET,
        archived: OptionalNullable[bool] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        show_as: OptionalNullable[models.ShowAs] = UNSET,
        done: OptionalNullable[bool] = UNSET,
        start_datetime: OptionalNullable[str] = UNSET,
        end_datetime: OptionalNullable[str] = UNSET,
        activity_date: OptionalNullable[str] = UNSET,
        end_date: OptionalNullable[str] = UNSET,
        recurrent: Optional[bool] = None,
        reminder_datetime: OptionalNullable[str] = UNSET,
        reminder_set: OptionalNullable[bool] = UNSET,
        video_conference_url: OptionalNullable[str] = UNSET,
        video_conference_id: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        attendees: Optional[
            Union[
                List[models.ActivityAttendeeInput],
                List[models.ActivityAttendeeInputTypedDict],
            ]
        ] = None,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesAddResponse:
        r"""Create activity

        Create activity

        :param type: The type of the activity
        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param activity_datetime: The date and time of the activity
        :param duration_seconds: The duration of the activity in seconds
        :param user_id: The user related to the activity
        :param account_id: The account related to the activity
        :param contact_id: The contact related to the activity
        :param company_id: The company related to the activity
        :param opportunity_id: The opportunity related to the activity
        :param lead_id: The lead related to the activity
        :param owner_id: The owner of the activity
        :param campaign_id: The campaign related to the activity
        :param case_id: The case related to the activity
        :param asset_id: The asset related to the activity
        :param contract_id: The contract related to the activity
        :param product_id: The product related to the activity
        :param solution_id: The solution related to the activity
        :param custom_object_id: The custom object related to the activity
        :param title: The title of the activity
        :param description: A description of the activity
        :param note: An internal note about the activity
        :param location: The location of the activity
        :param location_address:
        :param all_day_event: Whether the Activity is an all day event or not
        :param private: Whether the Activity is private or not
        :param group_event: Whether the Activity is a group event or not
        :param event_sub_type: The sub type of the group event
        :param group_event_type: The type of the group event
        :param child: Whether the activity is a child of another activity or not
        :param archived: Whether the activity is archived or not
        :param deleted: Whether the activity is deleted or not
        :param show_as:
        :param done: Whether the Activity is done or not
        :param start_datetime: The start date and time of the activity
        :param end_datetime: The end date and time of the activity
        :param activity_date: The date of the activity
        :param end_date: The end date of the activity
        :param recurrent: Whether the activity is recurrent or not
        :param reminder_datetime: The date and time of the reminder
        :param reminder_set: Whether the reminder is set or not
        :param video_conference_url: The URL of the video conference
        :param video_conference_id: The ID of the video conference
        :param custom_fields: Custom fields of the activity
        :param attendees:
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesAddRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            activity=models.ActivityInput(
                activity_datetime=activity_datetime,
                duration_seconds=duration_seconds,
                user_id=user_id,
                account_id=account_id,
                contact_id=contact_id,
                company_id=company_id,
                opportunity_id=opportunity_id,
                lead_id=lead_id,
                owner_id=owner_id,
                campaign_id=campaign_id,
                case_id=case_id,
                asset_id=asset_id,
                contract_id=contract_id,
                product_id=product_id,
                solution_id=solution_id,
                custom_object_id=custom_object_id,
                type=type_,
                title=title,
                description=description,
                note=note,
                location=location,
                location_address=utils.get_pydantic_model(
                    location_address, Optional[models.Address]
                ),
                all_day_event=all_day_event,
                private=private,
                group_event=group_event,
                event_sub_type=event_sub_type,
                group_event_type=group_event_type,
                child=child,
                archived=archived,
                deleted=deleted,
                show_as=show_as,
                done=done,
                start_datetime=start_datetime,
                end_datetime=end_datetime,
                activity_date=activity_date,
                end_date=end_date,
                recurrent=recurrent,
                reminder_datetime=reminder_datetime,
                reminder_set=reminder_set,
                video_conference_url=video_conference_url,
                video_conference_id=video_conference_id,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                attendees=utils.get_pydantic_model(
                    attendees, Optional[List[models.ActivityAttendeeInput]]
                ),
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/crm/activities",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesAddGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.activity, False, False, "json", models.ActivityInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesAdd",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return models.CrmActivitiesAddResponse(
                create_activity_response=unmarshal_json_response(
                    Optional[models.CreateActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesAddResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesOneResponse:
        r"""Get activity

        Get activity

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesOneRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            fields=fields,
        )

        req = self._build_request(
            method="GET",
            path="/crm/activities/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesOneGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesOne",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesOneResponse(
                get_activity_response=unmarshal_json_response(
                    Optional[models.GetActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesOneResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesOneResponse:
        r"""Get activity

        Get activity

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesOneRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            fields=fields,
        )

        req = self._build_request_async(
            method="GET",
            path="/crm/activities/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesOneGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesOne",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesOneResponse(
                get_activity_response=unmarshal_json_response(
                    Optional[models.GetActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesOneResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id: str,
        type_: Nullable[models.ActivityType],
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        activity_datetime: OptionalNullable[str] = UNSET,
        duration_seconds: OptionalNullable[int] = UNSET,
        user_id: OptionalNullable[str] = UNSET,
        account_id: OptionalNullable[str] = UNSET,
        contact_id: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        opportunity_id: OptionalNullable[str] = UNSET,
        lead_id: OptionalNullable[str] = UNSET,
        owner_id: OptionalNullable[str] = UNSET,
        campaign_id: OptionalNullable[str] = UNSET,
        case_id: OptionalNullable[str] = UNSET,
        asset_id: OptionalNullable[str] = UNSET,
        contract_id: OptionalNullable[str] = UNSET,
        product_id: OptionalNullable[str] = UNSET,
        solution_id: OptionalNullable[str] = UNSET,
        custom_object_id: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        note: OptionalNullable[str] = UNSET,
        location: OptionalNullable[str] = UNSET,
        location_address: Optional[
            Union[models.Address, models.AddressTypedDict]
        ] = None,
        all_day_event: OptionalNullable[bool] = UNSET,
        private: OptionalNullable[bool] = UNSET,
        group_event: OptionalNullable[bool] = UNSET,
        event_sub_type: OptionalNullable[str] = UNSET,
        group_event_type: OptionalNullable[str] = UNSET,
        child: OptionalNullable[bool] = UNSET,
        archived: OptionalNullable[bool] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        show_as: OptionalNullable[models.ShowAs] = UNSET,
        done: OptionalNullable[bool] = UNSET,
        start_datetime: OptionalNullable[str] = UNSET,
        end_datetime: OptionalNullable[str] = UNSET,
        activity_date: OptionalNullable[str] = UNSET,
        end_date: OptionalNullable[str] = UNSET,
        recurrent: Optional[bool] = None,
        reminder_datetime: OptionalNullable[str] = UNSET,
        reminder_set: OptionalNullable[bool] = UNSET,
        video_conference_url: OptionalNullable[str] = UNSET,
        video_conference_id: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        attendees: Optional[
            Union[
                List[models.ActivityAttendeeInput],
                List[models.ActivityAttendeeInputTypedDict],
            ]
        ] = None,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesUpdateResponse:
        r"""Update activity

        Update activity

        :param id: ID of the record you are acting upon.
        :param type: The type of the activity
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param activity_datetime: The date and time of the activity
        :param duration_seconds: The duration of the activity in seconds
        :param user_id: The user related to the activity
        :param account_id: The account related to the activity
        :param contact_id: The contact related to the activity
        :param company_id: The company related to the activity
        :param opportunity_id: The opportunity related to the activity
        :param lead_id: The lead related to the activity
        :param owner_id: The owner of the activity
        :param campaign_id: The campaign related to the activity
        :param case_id: The case related to the activity
        :param asset_id: The asset related to the activity
        :param contract_id: The contract related to the activity
        :param product_id: The product related to the activity
        :param solution_id: The solution related to the activity
        :param custom_object_id: The custom object related to the activity
        :param title: The title of the activity
        :param description: A description of the activity
        :param note: An internal note about the activity
        :param location: The location of the activity
        :param location_address:
        :param all_day_event: Whether the Activity is an all day event or not
        :param private: Whether the Activity is private or not
        :param group_event: Whether the Activity is a group event or not
        :param event_sub_type: The sub type of the group event
        :param group_event_type: The type of the group event
        :param child: Whether the activity is a child of another activity or not
        :param archived: Whether the activity is archived or not
        :param deleted: Whether the activity is deleted or not
        :param show_as:
        :param done: Whether the Activity is done or not
        :param start_datetime: The start date and time of the activity
        :param end_datetime: The end date and time of the activity
        :param activity_date: The date of the activity
        :param end_date: The end date of the activity
        :param recurrent: Whether the activity is recurrent or not
        :param reminder_datetime: The date and time of the reminder
        :param reminder_set: Whether the reminder is set or not
        :param video_conference_url: The URL of the video conference
        :param video_conference_id: The ID of the video conference
        :param custom_fields: Custom fields of the activity
        :param attendees:
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesUpdateRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            activity=models.ActivityInput(
                activity_datetime=activity_datetime,
                duration_seconds=duration_seconds,
                user_id=user_id,
                account_id=account_id,
                contact_id=contact_id,
                company_id=company_id,
                opportunity_id=opportunity_id,
                lead_id=lead_id,
                owner_id=owner_id,
                campaign_id=campaign_id,
                case_id=case_id,
                asset_id=asset_id,
                contract_id=contract_id,
                product_id=product_id,
                solution_id=solution_id,
                custom_object_id=custom_object_id,
                type=type_,
                title=title,
                description=description,
                note=note,
                location=location,
                location_address=utils.get_pydantic_model(
                    location_address, Optional[models.Address]
                ),
                all_day_event=all_day_event,
                private=private,
                group_event=group_event,
                event_sub_type=event_sub_type,
                group_event_type=group_event_type,
                child=child,
                archived=archived,
                deleted=deleted,
                show_as=show_as,
                done=done,
                start_datetime=start_datetime,
                end_datetime=end_datetime,
                activity_date=activity_date,
                end_date=end_date,
                recurrent=recurrent,
                reminder_datetime=reminder_datetime,
                reminder_set=reminder_set,
                video_conference_url=video_conference_url,
                video_conference_id=video_conference_id,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                attendees=utils.get_pydantic_model(
                    attendees, Optional[List[models.ActivityAttendeeInput]]
                ),
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/crm/activities/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesUpdateGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.activity, False, False, "json", models.ActivityInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesUpdate",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesUpdateResponse(
                update_activity_response=unmarshal_json_response(
                    Optional[models.UpdateActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesUpdateResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id: str,
        type_: Nullable[models.ActivityType],
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        activity_datetime: OptionalNullable[str] = UNSET,
        duration_seconds: OptionalNullable[int] = UNSET,
        user_id: OptionalNullable[str] = UNSET,
        account_id: OptionalNullable[str] = UNSET,
        contact_id: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        opportunity_id: OptionalNullable[str] = UNSET,
        lead_id: OptionalNullable[str] = UNSET,
        owner_id: OptionalNullable[str] = UNSET,
        campaign_id: OptionalNullable[str] = UNSET,
        case_id: OptionalNullable[str] = UNSET,
        asset_id: OptionalNullable[str] = UNSET,
        contract_id: OptionalNullable[str] = UNSET,
        product_id: OptionalNullable[str] = UNSET,
        solution_id: OptionalNullable[str] = UNSET,
        custom_object_id: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        description: OptionalNullable[str] = UNSET,
        note: OptionalNullable[str] = UNSET,
        location: OptionalNullable[str] = UNSET,
        location_address: Optional[
            Union[models.Address, models.AddressTypedDict]
        ] = None,
        all_day_event: OptionalNullable[bool] = UNSET,
        private: OptionalNullable[bool] = UNSET,
        group_event: OptionalNullable[bool] = UNSET,
        event_sub_type: OptionalNullable[str] = UNSET,
        group_event_type: OptionalNullable[str] = UNSET,
        child: OptionalNullable[bool] = UNSET,
        archived: OptionalNullable[bool] = UNSET,
        deleted: OptionalNullable[bool] = UNSET,
        show_as: OptionalNullable[models.ShowAs] = UNSET,
        done: OptionalNullable[bool] = UNSET,
        start_datetime: OptionalNullable[str] = UNSET,
        end_datetime: OptionalNullable[str] = UNSET,
        activity_date: OptionalNullable[str] = UNSET,
        end_date: OptionalNullable[str] = UNSET,
        recurrent: Optional[bool] = None,
        reminder_datetime: OptionalNullable[str] = UNSET,
        reminder_set: OptionalNullable[bool] = UNSET,
        video_conference_url: OptionalNullable[str] = UNSET,
        video_conference_id: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        attendees: Optional[
            Union[
                List[models.ActivityAttendeeInput],
                List[models.ActivityAttendeeInputTypedDict],
            ]
        ] = None,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesUpdateResponse:
        r"""Update activity

        Update activity

        :param id: ID of the record you are acting upon.
        :param type: The type of the activity
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param activity_datetime: The date and time of the activity
        :param duration_seconds: The duration of the activity in seconds
        :param user_id: The user related to the activity
        :param account_id: The account related to the activity
        :param contact_id: The contact related to the activity
        :param company_id: The company related to the activity
        :param opportunity_id: The opportunity related to the activity
        :param lead_id: The lead related to the activity
        :param owner_id: The owner of the activity
        :param campaign_id: The campaign related to the activity
        :param case_id: The case related to the activity
        :param asset_id: The asset related to the activity
        :param contract_id: The contract related to the activity
        :param product_id: The product related to the activity
        :param solution_id: The solution related to the activity
        :param custom_object_id: The custom object related to the activity
        :param title: The title of the activity
        :param description: A description of the activity
        :param note: An internal note about the activity
        :param location: The location of the activity
        :param location_address:
        :param all_day_event: Whether the Activity is an all day event or not
        :param private: Whether the Activity is private or not
        :param group_event: Whether the Activity is a group event or not
        :param event_sub_type: The sub type of the group event
        :param group_event_type: The type of the group event
        :param child: Whether the activity is a child of another activity or not
        :param archived: Whether the activity is archived or not
        :param deleted: Whether the activity is deleted or not
        :param show_as:
        :param done: Whether the Activity is done or not
        :param start_datetime: The start date and time of the activity
        :param end_datetime: The end date and time of the activity
        :param activity_date: The date of the activity
        :param end_date: The end date of the activity
        :param recurrent: Whether the activity is recurrent or not
        :param reminder_datetime: The date and time of the reminder
        :param reminder_set: Whether the reminder is set or not
        :param video_conference_url: The URL of the video conference
        :param video_conference_id: The ID of the video conference
        :param custom_fields: Custom fields of the activity
        :param attendees:
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesUpdateRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            activity=models.ActivityInput(
                activity_datetime=activity_datetime,
                duration_seconds=duration_seconds,
                user_id=user_id,
                account_id=account_id,
                contact_id=contact_id,
                company_id=company_id,
                opportunity_id=opportunity_id,
                lead_id=lead_id,
                owner_id=owner_id,
                campaign_id=campaign_id,
                case_id=case_id,
                asset_id=asset_id,
                contract_id=contract_id,
                product_id=product_id,
                solution_id=solution_id,
                custom_object_id=custom_object_id,
                type=type_,
                title=title,
                description=description,
                note=note,
                location=location,
                location_address=utils.get_pydantic_model(
                    location_address, Optional[models.Address]
                ),
                all_day_event=all_day_event,
                private=private,
                group_event=group_event,
                event_sub_type=event_sub_type,
                group_event_type=group_event_type,
                child=child,
                archived=archived,
                deleted=deleted,
                show_as=show_as,
                done=done,
                start_datetime=start_datetime,
                end_datetime=end_datetime,
                activity_date=activity_date,
                end_date=end_date,
                recurrent=recurrent,
                reminder_datetime=reminder_datetime,
                reminder_set=reminder_set,
                video_conference_url=video_conference_url,
                video_conference_id=video_conference_id,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                attendees=utils.get_pydantic_model(
                    attendees, Optional[List[models.ActivityAttendeeInput]]
                ),
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/crm/activities/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesUpdateGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.activity, False, False, "json", models.ActivityInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesUpdate",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesUpdateResponse(
                update_activity_response=unmarshal_json_response(
                    Optional[models.UpdateActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesUpdateResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesDeleteResponse:
        r"""Delete activity

        Delete activity

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesDeleteRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
        )

        req = self._build_request(
            method="DELETE",
            path="/crm/activities/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesDeleteGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesDelete",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesDeleteResponse(
                delete_activity_response=unmarshal_json_response(
                    Optional[models.DeleteActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesDeleteResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CrmActivitiesDeleteResponse:
        r"""Delete activity

        Delete activity

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CrmActivitiesDeleteRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/crm/activities/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CrmActivitiesDeleteGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="crm.activitiesDelete",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.CrmActivitiesDeleteResponse(
                delete_activity_response=unmarshal_json_response(
                    Optional[models.DeleteActivityResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.CrmActivitiesDeleteResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)
