"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from apideck_unify import models, utils
from apideck_unify._hooks import HookContext
from apideck_unify.types import OptionalNullable, UNSET
from apideck_unify.utils import get_security_from_env
from apideck_unify.utils.unmarshal_json_response import unmarshal_json_response
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union


class Customers(BaseSDK):
    def list(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        filter_: Optional[
            Union[models.CustomersFilter, models.CustomersFilterTypedDict]
        ] = None,
        sort: Optional[
            Union[models.CustomersSort, models.CustomersSortTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AccountingCustomersAllResponse]:
        r"""List Customers

        List Customers

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param cursor: Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.
        :param limit: Number of results to return. Minimum 1, Maximum 200, Default 20
        :param filter_: Apply filters
        :param sort: Apply sorting
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersAllRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            cursor=cursor,
            limit=limit,
            filter_=utils.get_pydantic_model(filter_, Optional[models.CustomersFilter]),
            sort=utils.get_pydantic_model(sort, Optional[models.CustomersSort]),
            pass_through=pass_through,
            fields=fields,
        )

        req = self._build_request(
            method="GET",
            path="/accounting/customers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersAllGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersAll",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.AccountingCustomersAllResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.cursors.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                raw=raw,
                consumer_id=consumer_id,
                app_id=app_id,
                service_id=service_id,
                cursor=next_cursor,
                limit=limit,
                filter_=filter_,
                sort=sort,
                pass_through=pass_through,
                fields=fields,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersAllResponse(
                get_customers_response=unmarshal_json_response(
                    Optional[models.GetCustomersResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersAllResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )

        raise models.APIError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        filter_: Optional[
            Union[models.CustomersFilter, models.CustomersFilterTypedDict]
        ] = None,
        sort: Optional[
            Union[models.CustomersSort, models.CustomersSortTypedDict]
        ] = None,
        pass_through: Optional[Dict[str, Any]] = None,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AccountingCustomersAllResponse]:
        r"""List Customers

        List Customers

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param cursor: Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.
        :param limit: Number of results to return. Minimum 1, Maximum 200, Default 20
        :param filter_: Apply filters
        :param sort: Apply sorting
        :param pass_through: Optional unmapped key/values that will be passed through to downstream as query parameters. Ie: ?pass_through[search]=leads becomes ?search=leads
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersAllRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            cursor=cursor,
            limit=limit,
            filter_=utils.get_pydantic_model(filter_, Optional[models.CustomersFilter]),
            sort=utils.get_pydantic_model(sort, Optional[models.CustomersSort]),
            pass_through=pass_through,
            fields=fields,
        )

        req = self._build_request_async(
            method="GET",
            path="/accounting/customers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersAllGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersAll",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.AccountingCustomersAllResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.cursors.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                raw=raw,
                consumer_id=consumer_id,
                app_id=app_id,
                service_id=service_id,
                cursor=next_cursor,
                limit=limit,
                filter_=filter_,
                sort=sort,
                pass_through=pass_through,
                fields=fields,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersAllResponse(
                get_customers_response=unmarshal_json_response(
                    Optional[models.GetCustomersResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersAllResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
                next=next_func,
            )

        raise models.APIError("Unexpected response received", http_res)

    def create(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        display_id: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        customer_category: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        suffix: OptionalNullable[str] = UNSET,
        individual: OptionalNullable[bool] = UNSET,
        project: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        websites: Optional[
            Union[List[models.Website], List[models.WebsiteTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        notes: OptionalNullable[str] = UNSET,
        tax_rate: Optional[
            Union[models.LinkedTaxRateInput, models.LinkedTaxRateInputTypedDict]
        ] = None,
        tax_number: OptionalNullable[str] = UNSET,
        taxable: OptionalNullable[bool] = UNSET,
        currency: OptionalNullable[models.Currency] = UNSET,
        account: OptionalNullable[
            Union[models.LinkedLedgerAccount, models.LinkedLedgerAccountTypedDict]
        ] = UNSET,
        parent: OptionalNullable[
            Union[models.LinkedParentCustomer, models.LinkedParentCustomerTypedDict]
        ] = UNSET,
        status: OptionalNullable[models.CustomerStatusStatus] = UNSET,
        payment_method: OptionalNullable[str] = UNSET,
        terms: OptionalNullable[str] = UNSET,
        channel: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        row_version: OptionalNullable[str] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersAddResponse:
        r"""Create Customer

        Create Customer

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param display_id: Display ID
        :param display_name: Display name
        :param company_name: The name of the company.
        :param company_id: The company ID the transaction belongs to
        :param customer_category: The category/type of the customer
        :param title: The job title of the person.
        :param first_name: The first name of the person.
        :param middle_name: Middle name of the person.
        :param last_name: The last name of the person.
        :param suffix:
        :param individual: Is this an individual or business customer
        :param project: If true, indicates this is a Project.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param websites:
        :param bank_accounts:
        :param notes: Some notes about this customer
        :param tax_rate:
        :param tax_number:
        :param taxable: Whether the entity is subject to taxation
        :param currency: Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217).
        :param account:
        :param parent: The parent customer this entity is linked to.
        :param status: Customer status
        :param payment_method: Payment method used for the transaction, such as cash, credit card, bank transfer, or check
        :param terms: Terms of payment.
        :param channel: The channel through which the transaction is processed.
        :param custom_fields:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersAddRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            customer=models.CustomerInput(
                display_id=display_id,
                display_name=display_name,
                company_name=company_name,
                company_id=company_id,
                customer_category=customer_category,
                title=title,
                first_name=first_name,
                middle_name=middle_name,
                last_name=last_name,
                suffix=suffix,
                individual=individual,
                project=project,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                websites=utils.get_pydantic_model(
                    websites, Optional[List[models.Website]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                notes=notes,
                tax_rate=utils.get_pydantic_model(
                    tax_rate, Optional[models.LinkedTaxRateInput]
                ),
                tax_number=tax_number,
                taxable=taxable,
                currency=currency,
                account=utils.get_pydantic_model(
                    account, OptionalNullable[models.LinkedLedgerAccount]
                ),
                parent=utils.get_pydantic_model(
                    parent, OptionalNullable[models.LinkedParentCustomer]
                ),
                status=status,
                payment_method=payment_method,
                terms=terms,
                channel=channel,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                row_version=row_version,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/accounting/customers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersAddGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.customer, False, False, "json", models.CustomerInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersAdd",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return models.AccountingCustomersAddResponse(
                create_customer_response=unmarshal_json_response(
                    Optional[models.CreateCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersAddResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        raw: Optional[bool] = False,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        display_id: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        customer_category: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        suffix: OptionalNullable[str] = UNSET,
        individual: OptionalNullable[bool] = UNSET,
        project: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        websites: Optional[
            Union[List[models.Website], List[models.WebsiteTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        notes: OptionalNullable[str] = UNSET,
        tax_rate: Optional[
            Union[models.LinkedTaxRateInput, models.LinkedTaxRateInputTypedDict]
        ] = None,
        tax_number: OptionalNullable[str] = UNSET,
        taxable: OptionalNullable[bool] = UNSET,
        currency: OptionalNullable[models.Currency] = UNSET,
        account: OptionalNullable[
            Union[models.LinkedLedgerAccount, models.LinkedLedgerAccountTypedDict]
        ] = UNSET,
        parent: OptionalNullable[
            Union[models.LinkedParentCustomer, models.LinkedParentCustomerTypedDict]
        ] = UNSET,
        status: OptionalNullable[models.CustomerStatusStatus] = UNSET,
        payment_method: OptionalNullable[str] = UNSET,
        terms: OptionalNullable[str] = UNSET,
        channel: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        row_version: OptionalNullable[str] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersAddResponse:
        r"""Create Customer

        Create Customer

        :param raw: Include raw response. Mostly used for debugging purposes
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param display_id: Display ID
        :param display_name: Display name
        :param company_name: The name of the company.
        :param company_id: The company ID the transaction belongs to
        :param customer_category: The category/type of the customer
        :param title: The job title of the person.
        :param first_name: The first name of the person.
        :param middle_name: Middle name of the person.
        :param last_name: The last name of the person.
        :param suffix:
        :param individual: Is this an individual or business customer
        :param project: If true, indicates this is a Project.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param websites:
        :param bank_accounts:
        :param notes: Some notes about this customer
        :param tax_rate:
        :param tax_number:
        :param taxable: Whether the entity is subject to taxation
        :param currency: Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217).
        :param account:
        :param parent: The parent customer this entity is linked to.
        :param status: Customer status
        :param payment_method: Payment method used for the transaction, such as cash, credit card, bank transfer, or check
        :param terms: Terms of payment.
        :param channel: The channel through which the transaction is processed.
        :param custom_fields:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersAddRequest(
            raw=raw,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            customer=models.CustomerInput(
                display_id=display_id,
                display_name=display_name,
                company_name=company_name,
                company_id=company_id,
                customer_category=customer_category,
                title=title,
                first_name=first_name,
                middle_name=middle_name,
                last_name=last_name,
                suffix=suffix,
                individual=individual,
                project=project,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                websites=utils.get_pydantic_model(
                    websites, Optional[List[models.Website]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                notes=notes,
                tax_rate=utils.get_pydantic_model(
                    tax_rate, Optional[models.LinkedTaxRateInput]
                ),
                tax_number=tax_number,
                taxable=taxable,
                currency=currency,
                account=utils.get_pydantic_model(
                    account, OptionalNullable[models.LinkedLedgerAccount]
                ),
                parent=utils.get_pydantic_model(
                    parent, OptionalNullable[models.LinkedParentCustomer]
                ),
                status=status,
                payment_method=payment_method,
                terms=terms,
                channel=channel,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                row_version=row_version,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/accounting/customers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersAddGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.customer, False, False, "json", models.CustomerInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersAdd",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return models.AccountingCustomersAddResponse(
                create_customer_response=unmarshal_json_response(
                    Optional[models.CreateCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersAddResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersOneResponse:
        r"""Get Customer

        Get Customer

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersOneRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            fields=fields,
        )

        req = self._build_request(
            method="GET",
            path="/accounting/customers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersOneGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersOne",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersOneResponse(
                get_customer_response=unmarshal_json_response(
                    Optional[models.GetCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersOneResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        fields: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersOneResponse:
        r"""Get Customer

        Get Customer

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param fields: The 'fields' parameter allows API users to specify the fields they want to include in the API response. If this parameter is not present, the API will return all available fields. If this parameter is present, only the fields specified in the comma-separated string will be included in the response. Nested properties can also be requested by using a dot notation. <br /><br />Example: `fields=name,email,addresses.city`<br /><br />In the example above, the response will only include the fields \"name\", \"email\" and \"addresses.city\". If any other fields are available, they will be excluded.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersOneRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            fields=fields,
        )

        req = self._build_request_async(
            method="GET",
            path="/accounting/customers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersOneGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersOne",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersOneResponse(
                get_customer_response=unmarshal_json_response(
                    Optional[models.GetCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersOneResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def update(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        display_id: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        customer_category: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        suffix: OptionalNullable[str] = UNSET,
        individual: OptionalNullable[bool] = UNSET,
        project: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        websites: Optional[
            Union[List[models.Website], List[models.WebsiteTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        notes: OptionalNullable[str] = UNSET,
        tax_rate: Optional[
            Union[models.LinkedTaxRateInput, models.LinkedTaxRateInputTypedDict]
        ] = None,
        tax_number: OptionalNullable[str] = UNSET,
        taxable: OptionalNullable[bool] = UNSET,
        currency: OptionalNullable[models.Currency] = UNSET,
        account: OptionalNullable[
            Union[models.LinkedLedgerAccount, models.LinkedLedgerAccountTypedDict]
        ] = UNSET,
        parent: OptionalNullable[
            Union[models.LinkedParentCustomer, models.LinkedParentCustomerTypedDict]
        ] = UNSET,
        status: OptionalNullable[models.CustomerStatusStatus] = UNSET,
        payment_method: OptionalNullable[str] = UNSET,
        terms: OptionalNullable[str] = UNSET,
        channel: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        row_version: OptionalNullable[str] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersUpdateResponse:
        r"""Update Customer

        Update Customer

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param display_id: Display ID
        :param display_name: Display name
        :param company_name: The name of the company.
        :param company_id: The company ID the transaction belongs to
        :param customer_category: The category/type of the customer
        :param title: The job title of the person.
        :param first_name: The first name of the person.
        :param middle_name: Middle name of the person.
        :param last_name: The last name of the person.
        :param suffix:
        :param individual: Is this an individual or business customer
        :param project: If true, indicates this is a Project.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param websites:
        :param bank_accounts:
        :param notes: Some notes about this customer
        :param tax_rate:
        :param tax_number:
        :param taxable: Whether the entity is subject to taxation
        :param currency: Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217).
        :param account:
        :param parent: The parent customer this entity is linked to.
        :param status: Customer status
        :param payment_method: Payment method used for the transaction, such as cash, credit card, bank transfer, or check
        :param terms: Terms of payment.
        :param channel: The channel through which the transaction is processed.
        :param custom_fields:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersUpdateRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            customer=models.CustomerInput(
                display_id=display_id,
                display_name=display_name,
                company_name=company_name,
                company_id=company_id,
                customer_category=customer_category,
                title=title,
                first_name=first_name,
                middle_name=middle_name,
                last_name=last_name,
                suffix=suffix,
                individual=individual,
                project=project,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                websites=utils.get_pydantic_model(
                    websites, Optional[List[models.Website]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                notes=notes,
                tax_rate=utils.get_pydantic_model(
                    tax_rate, Optional[models.LinkedTaxRateInput]
                ),
                tax_number=tax_number,
                taxable=taxable,
                currency=currency,
                account=utils.get_pydantic_model(
                    account, OptionalNullable[models.LinkedLedgerAccount]
                ),
                parent=utils.get_pydantic_model(
                    parent, OptionalNullable[models.LinkedParentCustomer]
                ),
                status=status,
                payment_method=payment_method,
                terms=terms,
                channel=channel,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                row_version=row_version,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/accounting/customers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersUpdateGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.customer, False, False, "json", models.CustomerInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersUpdate",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersUpdateResponse(
                update_customer_response=unmarshal_json_response(
                    Optional[models.UpdateCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersUpdateResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        display_id: OptionalNullable[str] = UNSET,
        display_name: OptionalNullable[str] = UNSET,
        company_name: OptionalNullable[str] = UNSET,
        company_id: OptionalNullable[str] = UNSET,
        customer_category: OptionalNullable[str] = UNSET,
        title: OptionalNullable[str] = UNSET,
        first_name: OptionalNullable[str] = UNSET,
        middle_name: OptionalNullable[str] = UNSET,
        last_name: OptionalNullable[str] = UNSET,
        suffix: OptionalNullable[str] = UNSET,
        individual: OptionalNullable[bool] = UNSET,
        project: OptionalNullable[bool] = UNSET,
        addresses: Optional[
            Union[List[models.Address], List[models.AddressTypedDict]]
        ] = None,
        phone_numbers: Optional[
            Union[List[models.PhoneNumber], List[models.PhoneNumberTypedDict]]
        ] = None,
        emails: Optional[Union[List[models.Email], List[models.EmailTypedDict]]] = None,
        websites: Optional[
            Union[List[models.Website], List[models.WebsiteTypedDict]]
        ] = None,
        bank_accounts: Optional[
            Union[List[models.BankAccount], List[models.BankAccountTypedDict]]
        ] = None,
        notes: OptionalNullable[str] = UNSET,
        tax_rate: Optional[
            Union[models.LinkedTaxRateInput, models.LinkedTaxRateInputTypedDict]
        ] = None,
        tax_number: OptionalNullable[str] = UNSET,
        taxable: OptionalNullable[bool] = UNSET,
        currency: OptionalNullable[models.Currency] = UNSET,
        account: OptionalNullable[
            Union[models.LinkedLedgerAccount, models.LinkedLedgerAccountTypedDict]
        ] = UNSET,
        parent: OptionalNullable[
            Union[models.LinkedParentCustomer, models.LinkedParentCustomerTypedDict]
        ] = UNSET,
        status: OptionalNullable[models.CustomerStatusStatus] = UNSET,
        payment_method: OptionalNullable[str] = UNSET,
        terms: OptionalNullable[str] = UNSET,
        channel: OptionalNullable[str] = UNSET,
        custom_fields: Optional[
            Union[List[models.CustomField], List[models.CustomFieldTypedDict]]
        ] = None,
        row_version: OptionalNullable[str] = UNSET,
        pass_through: Optional[
            Union[List[models.PassThroughBody], List[models.PassThroughBodyTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersUpdateResponse:
        r"""Update Customer

        Update Customer

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param display_id: Display ID
        :param display_name: Display name
        :param company_name: The name of the company.
        :param company_id: The company ID the transaction belongs to
        :param customer_category: The category/type of the customer
        :param title: The job title of the person.
        :param first_name: The first name of the person.
        :param middle_name: Middle name of the person.
        :param last_name: The last name of the person.
        :param suffix:
        :param individual: Is this an individual or business customer
        :param project: If true, indicates this is a Project.
        :param addresses:
        :param phone_numbers:
        :param emails:
        :param websites:
        :param bank_accounts:
        :param notes: Some notes about this customer
        :param tax_rate:
        :param tax_number:
        :param taxable: Whether the entity is subject to taxation
        :param currency: Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217).
        :param account:
        :param parent: The parent customer this entity is linked to.
        :param status: Customer status
        :param payment_method: Payment method used for the transaction, such as cash, credit card, bank transfer, or check
        :param terms: Terms of payment.
        :param channel: The channel through which the transaction is processed.
        :param custom_fields:
        :param row_version: A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object.
        :param pass_through: The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersUpdateRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
            customer=models.CustomerInput(
                display_id=display_id,
                display_name=display_name,
                company_name=company_name,
                company_id=company_id,
                customer_category=customer_category,
                title=title,
                first_name=first_name,
                middle_name=middle_name,
                last_name=last_name,
                suffix=suffix,
                individual=individual,
                project=project,
                addresses=utils.get_pydantic_model(
                    addresses, Optional[List[models.Address]]
                ),
                phone_numbers=utils.get_pydantic_model(
                    phone_numbers, Optional[List[models.PhoneNumber]]
                ),
                emails=utils.get_pydantic_model(emails, Optional[List[models.Email]]),
                websites=utils.get_pydantic_model(
                    websites, Optional[List[models.Website]]
                ),
                bank_accounts=utils.get_pydantic_model(
                    bank_accounts, Optional[List[models.BankAccount]]
                ),
                notes=notes,
                tax_rate=utils.get_pydantic_model(
                    tax_rate, Optional[models.LinkedTaxRateInput]
                ),
                tax_number=tax_number,
                taxable=taxable,
                currency=currency,
                account=utils.get_pydantic_model(
                    account, OptionalNullable[models.LinkedLedgerAccount]
                ),
                parent=utils.get_pydantic_model(
                    parent, OptionalNullable[models.LinkedParentCustomer]
                ),
                status=status,
                payment_method=payment_method,
                terms=terms,
                channel=channel,
                custom_fields=utils.get_pydantic_model(
                    custom_fields, Optional[List[models.CustomField]]
                ),
                row_version=row_version,
                pass_through=utils.get_pydantic_model(
                    pass_through, Optional[List[models.PassThroughBody]]
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/accounting/customers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersUpdateGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.customer, False, False, "json", models.CustomerInput
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersUpdate",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersUpdateResponse(
                update_customer_response=unmarshal_json_response(
                    Optional[models.UpdateCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersUpdateResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersDeleteResponse:
        r"""Delete Customer

        Delete Customer

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersDeleteRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
        )

        req = self._build_request(
            method="DELETE",
            path="/accounting/customers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersDeleteGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersDelete",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersDeleteResponse(
                delete_customer_response=unmarshal_json_response(
                    Optional[models.DeleteCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersDeleteResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        id: str,
        consumer_id: Optional[str] = None,
        app_id: Optional[str] = None,
        service_id: Optional[str] = None,
        raw: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AccountingCustomersDeleteResponse:
        r"""Delete Customer

        Delete Customer

        :param id: ID of the record you are acting upon.
        :param consumer_id: ID of the consumer which you want to get or push data from
        :param app_id: The ID of your Unify application
        :param service_id: Provide the service id you want to call (e.g., pipedrive). Only needed when a consumer has activated multiple integrations for a Unified API.
        :param raw: Include raw response. Mostly used for debugging purposes
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AccountingCustomersDeleteRequest(
            id=id,
            consumer_id=consumer_id,
            app_id=app_id,
            service_id=service_id,
            raw=raw,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/accounting/customers/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AccountingCustomersDeleteGlobals(
                consumer_id=self.sdk_configuration.globals.consumer_id,
                app_id=self.sdk_configuration.globals.app_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 900000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="accounting.customersDelete",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "402", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AccountingCustomersDeleteResponse(
                delete_customer_response=unmarshal_json_response(
                    Optional[models.DeleteCustomerResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseData, http_res
            )
            raise models.BadRequestResponse(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                models.UnauthorizedResponseData, http_res
            )
            raise models.UnauthorizedResponse(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                models.PaymentRequiredResponseData, http_res
            )
            raise models.PaymentRequiredResponse(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                models.NotFoundResponseData, http_res
            )
            raise models.NotFoundResponse(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.UnprocessableResponseData, http_res
            )
            raise models.UnprocessableResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "application/json"):
            return models.AccountingCustomersDeleteResponse(
                unexpected_error_response=unmarshal_json_response(
                    Optional[models.UnexpectedErrorResponse], http_res
                ),
                http_meta=models.HTTPMetadata(request=req, response=http_res),
            )

        raise models.APIError("Unexpected response received", http_res)
