"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from apideck_unify.apideck_companies import ApideckCompanies
from apideck_unify.apideck_departments import ApideckDepartments
from apideck_unify.employeepayrolls import EmployeePayrolls
from apideck_unify.employees import Employees
from apideck_unify.employeeschedules_sdk import EmployeeSchedulesSDK
from apideck_unify.payrolls import Payrolls
from apideck_unify.timeoffrequests import TimeOffRequests
from typing import Optional


class Hris(BaseSDK):
    employees: Employees
    companies: ApideckCompanies
    departments: ApideckDepartments
    payrolls: Payrolls
    employee_payrolls: EmployeePayrolls
    employee_schedules: EmployeeSchedulesSDK
    time_off_requests: TimeOffRequests

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.employees = Employees(self.sdk_configuration, parent_ref=self.parent_ref)
        self.companies = ApideckCompanies(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.departments = ApideckDepartments(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.payrolls = Payrolls(self.sdk_configuration, parent_ref=self.parent_ref)
        self.employee_payrolls = EmployeePayrolls(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.employee_schedules = EmployeeSchedulesSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.time_off_requests = TimeOffRequests(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
