"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from .customfield import CustomField, CustomFieldTypedDict
from .linkedledgeraccount import LinkedLedgerAccount, LinkedLedgerAccountTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class AccountingBankAccountAccountType(str, Enum):
    r"""The type of bank account"""

    CHECKING = "checking"
    SAVINGS = "savings"
    CREDIT_CARD = "credit_card"
    MONEY_MARKET = "money_market"
    LINE_OF_CREDIT = "line_of_credit"
    OTHER = "other"
    CASH = "cash"


class AccountingBankAccountStatus(str, Enum):
    r"""The status of the bank account"""

    ACTIVE = "active"
    INACTIVE = "inactive"
    CLOSED = "closed"


class AccountingBankAccountTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    downstream_id: NotRequired[Nullable[str]]
    r"""The third-party API ID of original entity"""
    display_id: NotRequired[Nullable[str]]
    r"""Display ID for the bank account"""
    name: NotRequired[Nullable[str]]
    r"""The name of the bank account"""
    account_number: NotRequired[Nullable[str]]
    r"""The bank account number"""
    account_type: NotRequired[AccountingBankAccountAccountType]
    r"""The type of bank account"""
    ledger_account: NotRequired[Nullable[LinkedLedgerAccountTypedDict]]
    bank_name: NotRequired[Nullable[str]]
    r"""The name of the bank or financial institution"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    balance: NotRequired[Nullable[float]]
    r"""The current balance of the bank account"""
    available_balance: NotRequired[Nullable[float]]
    r"""The available balance (considering pending transactions and overdraft)"""
    overdraft_limit: NotRequired[Nullable[float]]
    r"""The overdraft limit for the account"""
    routing_number: NotRequired[Nullable[str]]
    r"""Bank routing number (US)"""
    iban: NotRequired[Nullable[str]]
    r"""International Bank Account Number"""
    bic: NotRequired[Nullable[str]]
    r"""Bank Identifier Code / SWIFT Code"""
    bsb_number: NotRequired[Nullable[str]]
    r"""Bank State Branch number (Australia/New Zealand)"""
    branch_identifier: NotRequired[Nullable[str]]
    r"""Bank branch identifier"""
    bank_code: NotRequired[Nullable[str]]
    r"""Bank code assigned by central bank"""
    country: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""
    status: NotRequired[Nullable[AccountingBankAccountStatus]]
    r"""The status of the bank account"""
    description: NotRequired[Nullable[str]]
    r"""Description or notes about the bank account"""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""


class AccountingBankAccount(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    downstream_id: OptionalNullable[str] = UNSET
    r"""The third-party API ID of original entity"""

    display_id: OptionalNullable[str] = UNSET
    r"""Display ID for the bank account"""

    name: OptionalNullable[str] = UNSET
    r"""The name of the bank account"""

    account_number: OptionalNullable[str] = UNSET
    r"""The bank account number"""

    account_type: Optional[AccountingBankAccountAccountType] = None
    r"""The type of bank account"""

    ledger_account: OptionalNullable[LinkedLedgerAccount] = UNSET

    bank_name: OptionalNullable[str] = UNSET
    r"""The name of the bank or financial institution"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    balance: OptionalNullable[float] = UNSET
    r"""The current balance of the bank account"""

    available_balance: OptionalNullable[float] = UNSET
    r"""The available balance (considering pending transactions and overdraft)"""

    overdraft_limit: OptionalNullable[float] = UNSET
    r"""The overdraft limit for the account"""

    routing_number: OptionalNullable[str] = UNSET
    r"""Bank routing number (US)"""

    iban: OptionalNullable[str] = UNSET
    r"""International Bank Account Number"""

    bic: OptionalNullable[str] = UNSET
    r"""Bank Identifier Code / SWIFT Code"""

    bsb_number: OptionalNullable[str] = UNSET
    r"""Bank State Branch number (Australia/New Zealand)"""

    branch_identifier: OptionalNullable[str] = UNSET
    r"""Bank branch identifier"""

    bank_code: OptionalNullable[str] = UNSET
    r"""Bank code assigned by central bank"""

    country: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    status: OptionalNullable[AccountingBankAccountStatus] = UNSET
    r"""The status of the bank account"""

    description: OptionalNullable[str] = UNSET
    r"""Description or notes about the bank account"""

    custom_fields: Optional[List[CustomField]] = None

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "downstream_id",
            "display_id",
            "name",
            "account_number",
            "account_type",
            "ledger_account",
            "bank_name",
            "currency",
            "balance",
            "available_balance",
            "overdraft_limit",
            "routing_number",
            "iban",
            "bic",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "country",
            "status",
            "description",
            "custom_fields",
            "custom_mappings",
            "created_at",
            "updated_at",
            "created_by",
            "updated_by",
        ]
        nullable_fields = [
            "downstream_id",
            "display_id",
            "name",
            "account_number",
            "ledger_account",
            "bank_name",
            "currency",
            "balance",
            "available_balance",
            "overdraft_limit",
            "routing_number",
            "iban",
            "bic",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "country",
            "status",
            "description",
            "custom_mappings",
            "created_at",
            "updated_at",
            "created_by",
            "updated_by",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AccountingBankAccountInputTypedDict(TypedDict):
    display_id: NotRequired[Nullable[str]]
    r"""Display ID for the bank account"""
    name: NotRequired[Nullable[str]]
    r"""The name of the bank account"""
    account_number: NotRequired[Nullable[str]]
    r"""The bank account number"""
    account_type: NotRequired[AccountingBankAccountAccountType]
    r"""The type of bank account"""
    ledger_account: NotRequired[Nullable[LinkedLedgerAccountTypedDict]]
    bank_name: NotRequired[Nullable[str]]
    r"""The name of the bank or financial institution"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    balance: NotRequired[Nullable[float]]
    r"""The current balance of the bank account"""
    available_balance: NotRequired[Nullable[float]]
    r"""The available balance (considering pending transactions and overdraft)"""
    overdraft_limit: NotRequired[Nullable[float]]
    r"""The overdraft limit for the account"""
    routing_number: NotRequired[Nullable[str]]
    r"""Bank routing number (US)"""
    iban: NotRequired[Nullable[str]]
    r"""International Bank Account Number"""
    bic: NotRequired[Nullable[str]]
    r"""Bank Identifier Code / SWIFT Code"""
    bsb_number: NotRequired[Nullable[str]]
    r"""Bank State Branch number (Australia/New Zealand)"""
    branch_identifier: NotRequired[Nullable[str]]
    r"""Bank branch identifier"""
    bank_code: NotRequired[Nullable[str]]
    r"""Bank code assigned by central bank"""
    country: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""
    status: NotRequired[Nullable[AccountingBankAccountStatus]]
    r"""The status of the bank account"""
    description: NotRequired[Nullable[str]]
    r"""Description or notes about the bank account"""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]


class AccountingBankAccountInput(BaseModel):
    display_id: OptionalNullable[str] = UNSET
    r"""Display ID for the bank account"""

    name: OptionalNullable[str] = UNSET
    r"""The name of the bank account"""

    account_number: OptionalNullable[str] = UNSET
    r"""The bank account number"""

    account_type: Optional[AccountingBankAccountAccountType] = None
    r"""The type of bank account"""

    ledger_account: OptionalNullable[LinkedLedgerAccount] = UNSET

    bank_name: OptionalNullable[str] = UNSET
    r"""The name of the bank or financial institution"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    balance: OptionalNullable[float] = UNSET
    r"""The current balance of the bank account"""

    available_balance: OptionalNullable[float] = UNSET
    r"""The available balance (considering pending transactions and overdraft)"""

    overdraft_limit: OptionalNullable[float] = UNSET
    r"""The overdraft limit for the account"""

    routing_number: OptionalNullable[str] = UNSET
    r"""Bank routing number (US)"""

    iban: OptionalNullable[str] = UNSET
    r"""International Bank Account Number"""

    bic: OptionalNullable[str] = UNSET
    r"""Bank Identifier Code / SWIFT Code"""

    bsb_number: OptionalNullable[str] = UNSET
    r"""Bank State Branch number (Australia/New Zealand)"""

    branch_identifier: OptionalNullable[str] = UNSET
    r"""Bank branch identifier"""

    bank_code: OptionalNullable[str] = UNSET
    r"""Bank code assigned by central bank"""

    country: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    status: OptionalNullable[AccountingBankAccountStatus] = UNSET
    r"""The status of the bank account"""

    description: OptionalNullable[str] = UNSET
    r"""Description or notes about the bank account"""

    custom_fields: Optional[List[CustomField]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "display_id",
            "name",
            "account_number",
            "account_type",
            "ledger_account",
            "bank_name",
            "currency",
            "balance",
            "available_balance",
            "overdraft_limit",
            "routing_number",
            "iban",
            "bic",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "country",
            "status",
            "description",
            "custom_fields",
        ]
        nullable_fields = [
            "display_id",
            "name",
            "account_number",
            "ledger_account",
            "bank_name",
            "currency",
            "balance",
            "available_balance",
            "overdraft_limit",
            "routing_number",
            "iban",
            "bic",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "country",
            "status",
            "description",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
