"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .activityattendee import (
    ActivityAttendee,
    ActivityAttendeeInput,
    ActivityAttendeeInputTypedDict,
    ActivityAttendeeTypedDict,
)
from .address import Address, AddressTypedDict
from .customfield import CustomField, CustomFieldTypedDict
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class ActivityType(str, Enum):
    r"""The type of the activity"""

    CALL = "call"
    MEETING = "meeting"
    EMAIL = "email"
    NOTE = "note"
    TASK = "task"
    DEADLINE = "deadline"
    SEND_LETTER = "send-letter"
    SEND_QUOTE = "send-quote"
    OTHER = "other"


class ShowAs(str, Enum):
    FREE = "free"
    BUSY = "busy"


class ActivityTypedDict(TypedDict):
    type: Nullable[ActivityType]
    r"""The type of the activity"""
    id: NotRequired[str]
    r"""The unique identifier of the activity"""
    downstream_id: NotRequired[Nullable[str]]
    r"""The third-party API ID of original entity"""
    activity_datetime: NotRequired[Nullable[str]]
    r"""The date and time of the activity"""
    duration_seconds: NotRequired[Nullable[int]]
    r"""The duration of the activity in seconds"""
    user_id: NotRequired[Nullable[str]]
    r"""The user related to the activity"""
    account_id: NotRequired[Nullable[str]]
    r"""The account related to the activity"""
    contact_id: NotRequired[Nullable[str]]
    r"""The contact related to the activity"""
    company_id: NotRequired[Nullable[str]]
    r"""The company related to the activity"""
    opportunity_id: NotRequired[Nullable[str]]
    r"""The opportunity related to the activity"""
    lead_id: NotRequired[Nullable[str]]
    r"""The lead related to the activity"""
    owner_id: NotRequired[Nullable[str]]
    r"""The owner of the activity"""
    campaign_id: NotRequired[Nullable[str]]
    r"""The campaign related to the activity"""
    case_id: NotRequired[Nullable[str]]
    r"""The case related to the activity"""
    asset_id: NotRequired[Nullable[str]]
    r"""The asset related to the activity"""
    contract_id: NotRequired[Nullable[str]]
    r"""The contract related to the activity"""
    product_id: NotRequired[Nullable[str]]
    r"""The product related to the activity"""
    solution_id: NotRequired[Nullable[str]]
    r"""The solution related to the activity"""
    custom_object_id: NotRequired[Nullable[str]]
    r"""The custom object related to the activity"""
    title: NotRequired[Nullable[str]]
    r"""The title of the activity"""
    description: NotRequired[Nullable[str]]
    r"""A description of the activity"""
    note: NotRequired[Nullable[str]]
    r"""An internal note about the activity"""
    location: NotRequired[Nullable[str]]
    r"""The location of the activity"""
    location_address: NotRequired[AddressTypedDict]
    all_day_event: NotRequired[Nullable[bool]]
    r"""Whether the Activity is an all day event or not"""
    private: NotRequired[Nullable[bool]]
    r"""Whether the Activity is private or not"""
    group_event: NotRequired[Nullable[bool]]
    r"""Whether the Activity is a group event or not"""
    event_sub_type: NotRequired[Nullable[str]]
    r"""The sub type of the group event"""
    group_event_type: NotRequired[Nullable[str]]
    r"""The type of the group event"""
    child: NotRequired[Nullable[bool]]
    r"""Whether the activity is a child of another activity or not"""
    archived: NotRequired[Nullable[bool]]
    r"""Whether the activity is archived or not"""
    deleted: NotRequired[Nullable[bool]]
    r"""Whether the activity is deleted or not"""
    show_as: NotRequired[Nullable[ShowAs]]
    done: NotRequired[Nullable[bool]]
    r"""Whether the Activity is done or not"""
    start_datetime: NotRequired[Nullable[str]]
    r"""The start date and time of the activity"""
    end_datetime: NotRequired[Nullable[str]]
    r"""The end date and time of the activity"""
    duration_minutes: NotRequired[Nullable[int]]
    r"""The duration of the activity in minutes"""
    activity_date: NotRequired[Nullable[str]]
    r"""The date of the activity"""
    end_date: NotRequired[Nullable[str]]
    r"""The end date of the activity"""
    recurrent: NotRequired[bool]
    r"""Whether the activity is recurrent or not"""
    reminder_datetime: NotRequired[Nullable[str]]
    r"""The date and time of the reminder"""
    reminder_set: NotRequired[Nullable[bool]]
    r"""Whether the reminder is set or not"""
    video_conference_url: NotRequired[Nullable[str]]
    r"""The URL of the video conference"""
    video_conference_id: NotRequired[Nullable[str]]
    r"""The ID of the video conference"""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    r"""Custom fields of the activity"""
    attendees: NotRequired[List[ActivityAttendeeTypedDict]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the activity"""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the activity"""
    updated_at: NotRequired[Nullable[str]]
    r"""The date and time when the activity was last updated"""
    created_at: NotRequired[Nullable[str]]
    r"""The date and time when the activity was created"""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Activity(BaseModel):
    type: Nullable[ActivityType]
    r"""The type of the activity"""

    id: Optional[str] = None
    r"""The unique identifier of the activity"""

    downstream_id: OptionalNullable[str] = UNSET
    r"""The third-party API ID of original entity"""

    activity_datetime: OptionalNullable[str] = UNSET
    r"""The date and time of the activity"""

    duration_seconds: OptionalNullable[int] = UNSET
    r"""The duration of the activity in seconds"""

    user_id: OptionalNullable[str] = UNSET
    r"""The user related to the activity"""

    account_id: OptionalNullable[str] = UNSET
    r"""The account related to the activity"""

    contact_id: OptionalNullable[str] = UNSET
    r"""The contact related to the activity"""

    company_id: OptionalNullable[str] = UNSET
    r"""The company related to the activity"""

    opportunity_id: OptionalNullable[str] = UNSET
    r"""The opportunity related to the activity"""

    lead_id: OptionalNullable[str] = UNSET
    r"""The lead related to the activity"""

    owner_id: OptionalNullable[str] = UNSET
    r"""The owner of the activity"""

    campaign_id: OptionalNullable[str] = UNSET
    r"""The campaign related to the activity"""

    case_id: OptionalNullable[str] = UNSET
    r"""The case related to the activity"""

    asset_id: OptionalNullable[str] = UNSET
    r"""The asset related to the activity"""

    contract_id: OptionalNullable[str] = UNSET
    r"""The contract related to the activity"""

    product_id: OptionalNullable[str] = UNSET
    r"""The product related to the activity"""

    solution_id: OptionalNullable[str] = UNSET
    r"""The solution related to the activity"""

    custom_object_id: OptionalNullable[str] = UNSET
    r"""The custom object related to the activity"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the activity"""

    description: OptionalNullable[str] = UNSET
    r"""A description of the activity"""

    note: OptionalNullable[str] = UNSET
    r"""An internal note about the activity"""

    location: OptionalNullable[str] = UNSET
    r"""The location of the activity"""

    location_address: Optional[Address] = None

    all_day_event: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is an all day event or not"""

    private: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is private or not"""

    group_event: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is a group event or not"""

    event_sub_type: OptionalNullable[str] = UNSET
    r"""The sub type of the group event"""

    group_event_type: OptionalNullable[str] = UNSET
    r"""The type of the group event"""

    child: OptionalNullable[bool] = UNSET
    r"""Whether the activity is a child of another activity or not"""

    archived: OptionalNullable[bool] = UNSET
    r"""Whether the activity is archived or not"""

    deleted: OptionalNullable[bool] = UNSET
    r"""Whether the activity is deleted or not"""

    show_as: OptionalNullable[ShowAs] = UNSET

    done: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is done or not"""

    start_datetime: OptionalNullable[str] = UNSET
    r"""The start date and time of the activity"""

    end_datetime: OptionalNullable[str] = UNSET
    r"""The end date and time of the activity"""

    duration_minutes: OptionalNullable[int] = UNSET
    r"""The duration of the activity in minutes"""

    activity_date: OptionalNullable[str] = UNSET
    r"""The date of the activity"""

    end_date: OptionalNullable[str] = UNSET
    r"""The end date of the activity"""

    recurrent: Optional[bool] = None
    r"""Whether the activity is recurrent or not"""

    reminder_datetime: OptionalNullable[str] = UNSET
    r"""The date and time of the reminder"""

    reminder_set: OptionalNullable[bool] = UNSET
    r"""Whether the reminder is set or not"""

    video_conference_url: OptionalNullable[str] = UNSET
    r"""The URL of the video conference"""

    video_conference_id: OptionalNullable[str] = UNSET
    r"""The ID of the video conference"""

    custom_fields: Optional[List[CustomField]] = None
    r"""Custom fields of the activity"""

    attendees: Optional[List[ActivityAttendee]] = None

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the activity"""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the activity"""

    updated_at: OptionalNullable[str] = UNSET
    r"""The date and time when the activity was last updated"""

    created_at: OptionalNullable[str] = UNSET
    r"""The date and time when the activity was created"""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "downstream_id",
            "activity_datetime",
            "duration_seconds",
            "user_id",
            "account_id",
            "contact_id",
            "company_id",
            "opportunity_id",
            "lead_id",
            "owner_id",
            "campaign_id",
            "case_id",
            "asset_id",
            "contract_id",
            "product_id",
            "solution_id",
            "custom_object_id",
            "title",
            "description",
            "note",
            "location",
            "location_address",
            "all_day_event",
            "private",
            "group_event",
            "event_sub_type",
            "group_event_type",
            "child",
            "archived",
            "deleted",
            "show_as",
            "done",
            "start_datetime",
            "end_datetime",
            "duration_minutes",
            "activity_date",
            "end_date",
            "recurrent",
            "reminder_datetime",
            "reminder_set",
            "video_conference_url",
            "video_conference_id",
            "custom_fields",
            "attendees",
            "custom_mappings",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "downstream_id",
            "activity_datetime",
            "duration_seconds",
            "user_id",
            "account_id",
            "contact_id",
            "company_id",
            "opportunity_id",
            "lead_id",
            "owner_id",
            "campaign_id",
            "case_id",
            "asset_id",
            "contract_id",
            "product_id",
            "solution_id",
            "custom_object_id",
            "type",
            "title",
            "description",
            "note",
            "location",
            "all_day_event",
            "private",
            "group_event",
            "event_sub_type",
            "group_event_type",
            "child",
            "archived",
            "deleted",
            "show_as",
            "done",
            "start_datetime",
            "end_datetime",
            "duration_minutes",
            "activity_date",
            "end_date",
            "reminder_datetime",
            "reminder_set",
            "video_conference_url",
            "video_conference_id",
            "custom_mappings",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ActivityInputTypedDict(TypedDict):
    type: Nullable[ActivityType]
    r"""The type of the activity"""
    activity_datetime: NotRequired[Nullable[str]]
    r"""The date and time of the activity"""
    duration_seconds: NotRequired[Nullable[int]]
    r"""The duration of the activity in seconds"""
    user_id: NotRequired[Nullable[str]]
    r"""The user related to the activity"""
    account_id: NotRequired[Nullable[str]]
    r"""The account related to the activity"""
    contact_id: NotRequired[Nullable[str]]
    r"""The contact related to the activity"""
    company_id: NotRequired[Nullable[str]]
    r"""The company related to the activity"""
    opportunity_id: NotRequired[Nullable[str]]
    r"""The opportunity related to the activity"""
    lead_id: NotRequired[Nullable[str]]
    r"""The lead related to the activity"""
    owner_id: NotRequired[Nullable[str]]
    r"""The owner of the activity"""
    campaign_id: NotRequired[Nullable[str]]
    r"""The campaign related to the activity"""
    case_id: NotRequired[Nullable[str]]
    r"""The case related to the activity"""
    asset_id: NotRequired[Nullable[str]]
    r"""The asset related to the activity"""
    contract_id: NotRequired[Nullable[str]]
    r"""The contract related to the activity"""
    product_id: NotRequired[Nullable[str]]
    r"""The product related to the activity"""
    solution_id: NotRequired[Nullable[str]]
    r"""The solution related to the activity"""
    custom_object_id: NotRequired[Nullable[str]]
    r"""The custom object related to the activity"""
    title: NotRequired[Nullable[str]]
    r"""The title of the activity"""
    description: NotRequired[Nullable[str]]
    r"""A description of the activity"""
    note: NotRequired[Nullable[str]]
    r"""An internal note about the activity"""
    location: NotRequired[Nullable[str]]
    r"""The location of the activity"""
    location_address: NotRequired[AddressTypedDict]
    all_day_event: NotRequired[Nullable[bool]]
    r"""Whether the Activity is an all day event or not"""
    private: NotRequired[Nullable[bool]]
    r"""Whether the Activity is private or not"""
    group_event: NotRequired[Nullable[bool]]
    r"""Whether the Activity is a group event or not"""
    event_sub_type: NotRequired[Nullable[str]]
    r"""The sub type of the group event"""
    group_event_type: NotRequired[Nullable[str]]
    r"""The type of the group event"""
    child: NotRequired[Nullable[bool]]
    r"""Whether the activity is a child of another activity or not"""
    archived: NotRequired[Nullable[bool]]
    r"""Whether the activity is archived or not"""
    deleted: NotRequired[Nullable[bool]]
    r"""Whether the activity is deleted or not"""
    show_as: NotRequired[Nullable[ShowAs]]
    done: NotRequired[Nullable[bool]]
    r"""Whether the Activity is done or not"""
    start_datetime: NotRequired[Nullable[str]]
    r"""The start date and time of the activity"""
    end_datetime: NotRequired[Nullable[str]]
    r"""The end date and time of the activity"""
    activity_date: NotRequired[Nullable[str]]
    r"""The date of the activity"""
    end_date: NotRequired[Nullable[str]]
    r"""The end date of the activity"""
    recurrent: NotRequired[bool]
    r"""Whether the activity is recurrent or not"""
    reminder_datetime: NotRequired[Nullable[str]]
    r"""The date and time of the reminder"""
    reminder_set: NotRequired[Nullable[bool]]
    r"""Whether the reminder is set or not"""
    video_conference_url: NotRequired[Nullable[str]]
    r"""The URL of the video conference"""
    video_conference_id: NotRequired[Nullable[str]]
    r"""The ID of the video conference"""
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    r"""Custom fields of the activity"""
    attendees: NotRequired[List[ActivityAttendeeInputTypedDict]]
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class ActivityInput(BaseModel):
    type: Nullable[ActivityType]
    r"""The type of the activity"""

    activity_datetime: OptionalNullable[str] = UNSET
    r"""The date and time of the activity"""

    duration_seconds: OptionalNullable[int] = UNSET
    r"""The duration of the activity in seconds"""

    user_id: OptionalNullable[str] = UNSET
    r"""The user related to the activity"""

    account_id: OptionalNullable[str] = UNSET
    r"""The account related to the activity"""

    contact_id: OptionalNullable[str] = UNSET
    r"""The contact related to the activity"""

    company_id: OptionalNullable[str] = UNSET
    r"""The company related to the activity"""

    opportunity_id: OptionalNullable[str] = UNSET
    r"""The opportunity related to the activity"""

    lead_id: OptionalNullable[str] = UNSET
    r"""The lead related to the activity"""

    owner_id: OptionalNullable[str] = UNSET
    r"""The owner of the activity"""

    campaign_id: OptionalNullable[str] = UNSET
    r"""The campaign related to the activity"""

    case_id: OptionalNullable[str] = UNSET
    r"""The case related to the activity"""

    asset_id: OptionalNullable[str] = UNSET
    r"""The asset related to the activity"""

    contract_id: OptionalNullable[str] = UNSET
    r"""The contract related to the activity"""

    product_id: OptionalNullable[str] = UNSET
    r"""The product related to the activity"""

    solution_id: OptionalNullable[str] = UNSET
    r"""The solution related to the activity"""

    custom_object_id: OptionalNullable[str] = UNSET
    r"""The custom object related to the activity"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the activity"""

    description: OptionalNullable[str] = UNSET
    r"""A description of the activity"""

    note: OptionalNullable[str] = UNSET
    r"""An internal note about the activity"""

    location: OptionalNullable[str] = UNSET
    r"""The location of the activity"""

    location_address: Optional[Address] = None

    all_day_event: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is an all day event or not"""

    private: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is private or not"""

    group_event: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is a group event or not"""

    event_sub_type: OptionalNullable[str] = UNSET
    r"""The sub type of the group event"""

    group_event_type: OptionalNullable[str] = UNSET
    r"""The type of the group event"""

    child: OptionalNullable[bool] = UNSET
    r"""Whether the activity is a child of another activity or not"""

    archived: OptionalNullable[bool] = UNSET
    r"""Whether the activity is archived or not"""

    deleted: OptionalNullable[bool] = UNSET
    r"""Whether the activity is deleted or not"""

    show_as: OptionalNullable[ShowAs] = UNSET

    done: OptionalNullable[bool] = UNSET
    r"""Whether the Activity is done or not"""

    start_datetime: OptionalNullable[str] = UNSET
    r"""The start date and time of the activity"""

    end_datetime: OptionalNullable[str] = UNSET
    r"""The end date and time of the activity"""

    activity_date: OptionalNullable[str] = UNSET
    r"""The date of the activity"""

    end_date: OptionalNullable[str] = UNSET
    r"""The end date of the activity"""

    recurrent: Optional[bool] = None
    r"""Whether the activity is recurrent or not"""

    reminder_datetime: OptionalNullable[str] = UNSET
    r"""The date and time of the reminder"""

    reminder_set: OptionalNullable[bool] = UNSET
    r"""Whether the reminder is set or not"""

    video_conference_url: OptionalNullable[str] = UNSET
    r"""The URL of the video conference"""

    video_conference_id: OptionalNullable[str] = UNSET
    r"""The ID of the video conference"""

    custom_fields: Optional[List[CustomField]] = None
    r"""Custom fields of the activity"""

    attendees: Optional[List[ActivityAttendeeInput]] = None

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "activity_datetime",
            "duration_seconds",
            "user_id",
            "account_id",
            "contact_id",
            "company_id",
            "opportunity_id",
            "lead_id",
            "owner_id",
            "campaign_id",
            "case_id",
            "asset_id",
            "contract_id",
            "product_id",
            "solution_id",
            "custom_object_id",
            "title",
            "description",
            "note",
            "location",
            "location_address",
            "all_day_event",
            "private",
            "group_event",
            "event_sub_type",
            "group_event_type",
            "child",
            "archived",
            "deleted",
            "show_as",
            "done",
            "start_datetime",
            "end_datetime",
            "activity_date",
            "end_date",
            "recurrent",
            "reminder_datetime",
            "reminder_set",
            "video_conference_url",
            "video_conference_id",
            "custom_fields",
            "attendees",
            "pass_through",
        ]
        nullable_fields = [
            "activity_datetime",
            "duration_seconds",
            "user_id",
            "account_id",
            "contact_id",
            "company_id",
            "opportunity_id",
            "lead_id",
            "owner_id",
            "campaign_id",
            "case_id",
            "asset_id",
            "contract_id",
            "product_id",
            "solution_id",
            "custom_object_id",
            "type",
            "title",
            "description",
            "note",
            "location",
            "all_day_event",
            "private",
            "group_event",
            "event_sub_type",
            "group_event_type",
            "child",
            "archived",
            "deleted",
            "show_as",
            "done",
            "start_datetime",
            "end_datetime",
            "activity_date",
            "end_date",
            "reminder_datetime",
            "reminder_set",
            "video_conference_url",
            "video_conference_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
