"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class ActivityAttendeeStatus(str, Enum):
    r"""Status of the attendee"""

    ACCEPTED = "accepted"
    TENTATIVE = "tentative"
    DECLINED = "declined"


class ActivityAttendeeTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the attendee"""
    name: NotRequired[Nullable[str]]
    r"""Full name of the attendee"""
    first_name: NotRequired[Nullable[str]]
    r"""First name of the attendee"""
    middle_name: NotRequired[Nullable[str]]
    r"""Middle name of the attendee"""
    last_name: NotRequired[Nullable[str]]
    r"""Last name of the attendee"""
    prefix: NotRequired[Nullable[str]]
    r"""Prefix of the attendee"""
    suffix: NotRequired[Nullable[str]]
    r"""Suffix of the attendee"""
    email_address: NotRequired[Nullable[str]]
    r"""Email address of the attendee"""
    is_organizer: NotRequired[Nullable[bool]]
    r"""Whether the attendee is the organizer of the activity"""
    status: NotRequired[Nullable[ActivityAttendeeStatus]]
    r"""Status of the attendee"""
    user_id: NotRequired[Nullable[str]]
    r"""The identifier for a related user"""
    contact_id: NotRequired[Nullable[str]]
    r"""The identifier for a related contact"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The last time the attendee was updated (ISO 8601)"""
    created_at: NotRequired[Nullable[datetime]]
    r"""The time the attendee was created (ISO 8601)"""


class ActivityAttendee(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the attendee"""

    name: OptionalNullable[str] = UNSET
    r"""Full name of the attendee"""

    first_name: OptionalNullable[str] = UNSET
    r"""First name of the attendee"""

    middle_name: OptionalNullable[str] = UNSET
    r"""Middle name of the attendee"""

    last_name: OptionalNullable[str] = UNSET
    r"""Last name of the attendee"""

    prefix: OptionalNullable[str] = UNSET
    r"""Prefix of the attendee"""

    suffix: OptionalNullable[str] = UNSET
    r"""Suffix of the attendee"""

    email_address: OptionalNullable[str] = UNSET
    r"""Email address of the attendee"""

    is_organizer: OptionalNullable[bool] = UNSET
    r"""Whether the attendee is the organizer of the activity"""

    status: OptionalNullable[ActivityAttendeeStatus] = UNSET
    r"""Status of the attendee"""

    user_id: OptionalNullable[str] = UNSET
    r"""The identifier for a related user"""

    contact_id: OptionalNullable[str] = UNSET
    r"""The identifier for a related contact"""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The last time the attendee was updated (ISO 8601)"""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The time the attendee was created (ISO 8601)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "first_name",
            "middle_name",
            "last_name",
            "prefix",
            "suffix",
            "email_address",
            "is_organizer",
            "status",
            "user_id",
            "contact_id",
            "updated_at",
            "created_at",
        ]
        nullable_fields = [
            "id",
            "name",
            "first_name",
            "middle_name",
            "last_name",
            "prefix",
            "suffix",
            "email_address",
            "is_organizer",
            "status",
            "user_id",
            "contact_id",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ActivityAttendeeInputTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""Full name of the attendee"""
    first_name: NotRequired[Nullable[str]]
    r"""First name of the attendee"""
    middle_name: NotRequired[Nullable[str]]
    r"""Middle name of the attendee"""
    last_name: NotRequired[Nullable[str]]
    r"""Last name of the attendee"""
    prefix: NotRequired[Nullable[str]]
    r"""Prefix of the attendee"""
    suffix: NotRequired[Nullable[str]]
    r"""Suffix of the attendee"""
    email_address: NotRequired[Nullable[str]]
    r"""Email address of the attendee"""
    is_organizer: NotRequired[Nullable[bool]]
    r"""Whether the attendee is the organizer of the activity"""
    status: NotRequired[Nullable[ActivityAttendeeStatus]]
    r"""Status of the attendee"""


class ActivityAttendeeInput(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""Full name of the attendee"""

    first_name: OptionalNullable[str] = UNSET
    r"""First name of the attendee"""

    middle_name: OptionalNullable[str] = UNSET
    r"""Middle name of the attendee"""

    last_name: OptionalNullable[str] = UNSET
    r"""Last name of the attendee"""

    prefix: OptionalNullable[str] = UNSET
    r"""Prefix of the attendee"""

    suffix: OptionalNullable[str] = UNSET
    r"""Suffix of the attendee"""

    email_address: OptionalNullable[str] = UNSET
    r"""Email address of the attendee"""

    is_organizer: OptionalNullable[bool] = UNSET
    r"""Whether the attendee is the organizer of the activity"""

    status: OptionalNullable[ActivityAttendeeStatus] = UNSET
    r"""Status of the attendee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "first_name",
            "middle_name",
            "last_name",
            "prefix",
            "suffix",
            "email_address",
            "is_organizer",
            "status",
        ]
        nullable_fields = [
            "name",
            "first_name",
            "middle_name",
            "last_name",
            "prefix",
            "suffix",
            "email_address",
            "is_organizer",
            "status",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
