"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .apistatus import APIStatus
from .resourcestatus import ResourceStatus
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class APIType(str, Enum):
    r"""Indicates whether the API is a Unified API. If unified_api is false, the API is a Platform API."""

    PLATFORM = "platform"
    UNIFIED = "unified"


class ResourcesTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the resource, typically a lowercased version of its name."""
    name: NotRequired[str]
    r"""Name of the resource (plural)"""
    status: NotRequired[ResourceStatus]
    r"""Status of the resource. Resources with status live or beta are callable."""
    excluded_from_coverage: NotRequired[bool]
    r"""Exclude from mapping coverage"""


class Resources(BaseModel):
    id: Optional[str] = None
    r"""ID of the resource, typically a lowercased version of its name."""

    name: Optional[str] = None
    r"""Name of the resource (plural)"""

    status: Optional[ResourceStatus] = None
    r"""Status of the resource. Resources with status live or beta are callable."""

    excluded_from_coverage: Optional[bool] = None
    r"""Exclude from mapping coverage"""


class APITypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the API."""
    type: NotRequired[APIType]
    r"""Indicates whether the API is a Unified API. If unified_api is false, the API is a Platform API."""
    name: NotRequired[str]
    r"""Name of the API."""
    description: NotRequired[Nullable[str]]
    r"""Description of the API."""
    status: NotRequired[APIStatus]
    r"""Status of the API. APIs with status live or beta are callable."""
    spec_url: NotRequired[str]
    r"""Link to the latest OpenAPI specification of the API."""
    api_reference_url: NotRequired[str]
    r"""Link to the API reference of the API."""
    postman_collection_id: NotRequired[Nullable[str]]
    r"""ID of the Postman collection of the API."""
    categories: NotRequired[List[str]]
    r"""List of categories the API belongs to."""
    resources: NotRequired[List[ResourcesTypedDict]]
    r"""List of resources supported in this API."""
    events: NotRequired[List[str]]
    r"""List of event types this API supports."""


class API(BaseModel):
    id: Optional[str] = None
    r"""ID of the API."""

    type: Optional[APIType] = None
    r"""Indicates whether the API is a Unified API. If unified_api is false, the API is a Platform API."""

    name: Optional[str] = None
    r"""Name of the API."""

    description: OptionalNullable[str] = UNSET
    r"""Description of the API."""

    status: Optional[APIStatus] = None
    r"""Status of the API. APIs with status live or beta are callable."""

    spec_url: Optional[str] = None
    r"""Link to the latest OpenAPI specification of the API."""

    api_reference_url: Optional[str] = None
    r"""Link to the API reference of the API."""

    postman_collection_id: OptionalNullable[str] = UNSET
    r"""ID of the Postman collection of the API."""

    categories: Optional[List[str]] = None
    r"""List of categories the API belongs to."""

    resources: Optional[List[Resources]] = None
    r"""List of resources supported in this API."""

    events: Optional[List[str]] = None
    r"""List of event types this API supports."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "type",
            "name",
            "description",
            "status",
            "spec_url",
            "api_reference_url",
            "postman_collection_id",
            "categories",
            "resources",
            "events",
        ]
        nullable_fields = ["description", "postman_collection_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
