"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .resourcestatus import ResourceStatus
from apideck_unify.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class LinkedResourcesTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the resource, typically a lowercased version of name."""
    unified_property: NotRequired[str]
    r"""Name of the property in our Unified API."""


class LinkedResources(BaseModel):
    id: Optional[str] = None
    r"""ID of the resource, typically a lowercased version of name."""

    unified_property: Optional[str] = None
    r"""Name of the property in our Unified API."""


class SchemaTypedDict(TypedDict):
    r"""JSON Schema of the resource in our Unified API"""


class Schema(BaseModel):
    r"""JSON Schema of the resource in our Unified API"""


class APIResourceTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the resource, typically a lowercased version of name."""
    name: NotRequired[str]
    r"""Name of the resource (plural)"""
    status: NotRequired[ResourceStatus]
    r"""Status of the resource. Resources with status live or beta are callable."""
    linked_resources: NotRequired[List[LinkedResourcesTypedDict]]
    r"""List of linked resources."""
    schema_: NotRequired[SchemaTypedDict]
    r"""JSON Schema of the resource in our Unified API"""


class APIResource(BaseModel):
    id: Optional[str] = None
    r"""ID of the resource, typically a lowercased version of name."""

    name: Optional[str] = None
    r"""Name of the resource (plural)"""

    status: Optional[ResourceStatus] = None
    r"""Status of the resource. Resources with status live or beta are callable."""

    linked_resources: Optional[List[LinkedResources]] = None
    r"""List of linked resources."""

    schema_: Annotated[Optional[Schema], pydantic.Field(alias="schema")] = None
    r"""JSON Schema of the resource in our Unified API"""
