"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class AccountType(str, Enum):
    r"""The type of bank account."""

    BANK_ACCOUNT = "bank_account"
    CREDIT_CARD = "credit_card"
    OTHER = "other"


class BankAccountTypedDict(TypedDict):
    bank_name: NotRequired[Nullable[str]]
    r"""The name of the bank or financial institution"""
    account_number: NotRequired[Nullable[str]]
    r"""The bank account number"""
    account_name: NotRequired[Nullable[str]]
    r"""The name of the bank account"""
    account_type: NotRequired[Nullable[AccountType]]
    r"""The type of bank account."""
    iban: NotRequired[Nullable[str]]
    r"""International Bank Account Number"""
    bic: NotRequired[Nullable[str]]
    r"""Bank Identifier Code / SWIFT Code"""
    routing_number: NotRequired[Nullable[str]]
    r"""Bank routing number (US)"""
    bsb_number: NotRequired[Nullable[str]]
    r"""Bank State Branch number (Australia/New Zealand)"""
    branch_identifier: NotRequired[Nullable[str]]
    r"""Bank branch identifier"""
    bank_code: NotRequired[Nullable[str]]
    r"""Bank code assigned by central bank"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    country: NotRequired[Nullable[str]]
    r"""Country code according to ISO 3166-1 alpha-2."""


class BankAccount(BaseModel):
    bank_name: OptionalNullable[str] = UNSET
    r"""The name of the bank or financial institution"""

    account_number: OptionalNullable[str] = UNSET
    r"""The bank account number"""

    account_name: OptionalNullable[str] = UNSET
    r"""The name of the bank account"""

    account_type: OptionalNullable[AccountType] = UNSET
    r"""The type of bank account."""

    iban: OptionalNullable[str] = UNSET
    r"""International Bank Account Number"""

    bic: OptionalNullable[str] = UNSET
    r"""Bank Identifier Code / SWIFT Code"""

    routing_number: OptionalNullable[str] = UNSET
    r"""Bank routing number (US)"""

    bsb_number: OptionalNullable[str] = UNSET
    r"""Bank State Branch number (Australia/New Zealand)"""

    branch_identifier: OptionalNullable[str] = UNSET
    r"""Bank branch identifier"""

    bank_code: OptionalNullable[str] = UNSET
    r"""Bank code assigned by central bank"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    country: OptionalNullable[str] = UNSET
    r"""Country code according to ISO 3166-1 alpha-2."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "bank_name",
            "account_number",
            "account_name",
            "account_type",
            "iban",
            "bic",
            "routing_number",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "currency",
            "country",
        ]
        nullable_fields = [
            "bank_name",
            "account_number",
            "account_name",
            "account_type",
            "iban",
            "bic",
            "routing_number",
            "bsb_number",
            "branch_identifier",
            "bank_code",
            "currency",
            "country",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
