"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import BaseModel
from apideck_unify.utils import FieldMetadata
from enum import Enum
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BankAccountsFilterAccountType(str, Enum):
    r"""Filter by account type"""

    CHECKING = "checking"
    SAVINGS = "savings"
    CREDIT_CARD = "credit_card"
    MONEY_MARKET = "money_market"
    LINE_OF_CREDIT = "line_of_credit"
    OTHER = "other"
    CASH = "cash"


class BankAccountsFilterStatus(str, Enum):
    r"""Filter by account status"""

    ACTIVE = "active"
    INACTIVE = "inactive"
    CLOSED = "closed"


class BankAccountsFilterTypedDict(TypedDict):
    name: NotRequired[str]
    r"""Filter by bank account name"""
    account_type: NotRequired[BankAccountsFilterAccountType]
    r"""Filter by account type"""
    status: NotRequired[BankAccountsFilterStatus]
    r"""Filter by account status"""


class BankAccountsFilter(BaseModel):
    name: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Filter by bank account name"""

    account_type: Annotated[
        Optional[BankAccountsFilterAccountType], FieldMetadata(query=True)
    ] = None
    r"""Filter by account type"""

    status: Annotated[Optional[BankAccountsFilterStatus], FieldMetadata(query=True)] = (
        None
    )
    r"""Filter by account status"""
