"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class CollectionTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    parent_id: NotRequired[Nullable[str]]
    r"""The collections's parent ID"""
    type: NotRequired[Nullable[str]]
    r"""The collections's type"""
    name: NotRequired[Nullable[str]]
    r"""Name of the collection"""
    description: NotRequired[Nullable[str]]
    r"""Description of the collection"""
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""


class Collection(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    parent_id: OptionalNullable[str] = UNSET
    r"""The collections's parent ID"""

    type: OptionalNullable[str] = UNSET
    r"""The collections's type"""

    name: OptionalNullable[str] = UNSET
    r"""Name of the collection"""

    description: OptionalNullable[str] = UNSET
    r"""Description of the collection"""

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "parent_id",
            "type",
            "name",
            "description",
            "custom_mappings",
            "updated_at",
            "created_at",
        ]
        nullable_fields = [
            "parent_id",
            "type",
            "name",
            "description",
            "custom_mappings",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
