"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefit import Benefit, BenefitTypedDict
from .deduction import Deduction, DeductionTypedDict
from .tax import Tax, TaxTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class CompensationTypedDict(TypedDict):
    employee_id: Nullable[str]
    r"""A unique identifier for an object."""
    net_pay: NotRequired[Nullable[float]]
    r"""The employee's net pay. Only available when payroll has been processed"""
    gross_pay: NotRequired[Nullable[float]]
    r"""The employee's gross pay. Only available when payroll has been processed"""
    taxes: NotRequired[Nullable[List[TaxTypedDict]]]
    r"""An array of employer and employee taxes for the pay period."""
    deductions: NotRequired[Nullable[List[DeductionTypedDict]]]
    r"""An array of employee deductions for the pay period."""
    benefits: NotRequired[Nullable[List[BenefitTypedDict]]]
    r"""An array of employee benefits for the pay period."""


class Compensation(BaseModel):
    employee_id: Nullable[str]
    r"""A unique identifier for an object."""

    net_pay: OptionalNullable[float] = UNSET
    r"""The employee's net pay. Only available when payroll has been processed"""

    gross_pay: OptionalNullable[float] = UNSET
    r"""The employee's gross pay. Only available when payroll has been processed"""

    taxes: OptionalNullable[List[Tax]] = UNSET
    r"""An array of employer and employee taxes for the pay period."""

    deductions: OptionalNullable[List[Deduction]] = UNSET
    r"""An array of employee deductions for the pay period."""

    benefits: OptionalNullable[List[Benefit]] = UNSET
    r"""An array of employee benefits for the pay period."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["net_pay", "gross_pay", "taxes", "deductions", "benefits"]
        nullable_fields = [
            "employee_id",
            "net_pay",
            "gross_pay",
            "taxes",
            "deductions",
            "benefits",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
