"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .connectordoc import ConnectorDoc, ConnectorDocTypedDict
from .connectorevent import ConnectorEvent, ConnectorEventTypedDict
from .connectorsetting import ConnectorSetting, ConnectorSettingTypedDict
from .connectorstatus import ConnectorStatus
from .linkedconnectorresource import (
    LinkedConnectorResource,
    LinkedConnectorResourceTypedDict,
)
from .schemasupport import SchemaSupport, SchemaSupportTypedDict
from .unifiedapiid import UnifiedAPIID
from .webhooksupport import WebhookSupport, WebhookSupportTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ConnectorAuthType(str, Enum):
    r"""Type of authorization used by the connector"""

    OAUTH2 = "oauth2"
    API_KEY = "apiKey"
    BASIC = "basic"
    CUSTOM = "custom"
    NONE = "none"


class ConnectorOauthGrantType(str, Enum):
    r"""OAuth grant type used by the connector. More info: https://oauth.net/2/grant-types"""

    AUTHORIZATION_CODE = "authorization_code"
    CLIENT_CREDENTIALS = "client_credentials"
    PASSWORD = "password"


class OauthCredentialsSource(str, Enum):
    r"""Location of the OAuth client credentials. For most connectors the OAuth client credentials are stored on integration and managed by the application owner. For others they are stored on connection and managed by the consumer in Vault."""

    INTEGRATION = "integration"
    CONNECTION = "connection"


class OauthScopesTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the OAuth scope."""
    label: NotRequired[str]
    r"""Label of the OAuth scope."""
    default_apis: NotRequired[List[str]]
    r"""List of Unified APIs that request this OAuth Scope by default. Application owners can customize the requested scopes."""


class OauthScopes(BaseModel):
    id: Optional[str] = None
    r"""ID of the OAuth scope."""

    label: Optional[str] = None
    r"""Label of the OAuth scope."""

    default_apis: Optional[List[str]] = None
    r"""List of Unified APIs that request this OAuth Scope by default. Application owners can customize the requested scopes."""


class ConnectorOauthScopesTypedDict(TypedDict):
    r"""OAuth scopes required for the connector. Add these scopes to your OAuth app."""

    id: NotRequired[str]
    r"""ID of the OAuth scope."""
    label: NotRequired[str]
    r"""Label of the OAuth scope."""


class ConnectorOauthScopes(BaseModel):
    r"""OAuth scopes required for the connector. Add these scopes to your OAuth app."""

    id: Optional[str] = None
    r"""ID of the OAuth scope."""

    label: Optional[str] = None
    r"""Label of the OAuth scope."""


class UnifiedApisTypedDict(TypedDict):
    id: NotRequired[UnifiedAPIID]
    r"""Name of Apideck Unified API"""
    name: NotRequired[str]
    r"""Name of the API."""
    auth_only: NotRequired[bool]
    r"""Indicates whether a connector only supports authentication. In this case the connector is not mapped to a Unified API, but can be used with the Proxy API"""
    oauth_scopes: NotRequired[List[ConnectorOauthScopesTypedDict]]
    supported_resources: NotRequired[List[LinkedConnectorResourceTypedDict]]
    r"""List of resources that are supported on the connector."""
    downstream_unsupported_resources: NotRequired[List[str]]
    r"""List of resources that are not supported on the downstream."""
    supported_events: NotRequired[List[ConnectorEventTypedDict]]
    r"""List of events that are supported on the connector for this Unified API."""


class UnifiedApis(BaseModel):
    id: Optional[UnifiedAPIID] = None
    r"""Name of Apideck Unified API"""

    name: Optional[str] = None
    r"""Name of the API."""

    auth_only: Optional[bool] = None
    r"""Indicates whether a connector only supports authentication. In this case the connector is not mapped to a Unified API, but can be used with the Proxy API"""

    oauth_scopes: Optional[List[ConnectorOauthScopes]] = None

    supported_resources: Optional[List[LinkedConnectorResource]] = None
    r"""List of resources that are supported on the connector."""

    downstream_unsupported_resources: Optional[List[str]] = None
    r"""List of resources that are not supported on the downstream."""

    supported_events: Optional[List[ConnectorEvent]] = None
    r"""List of events that are supported on the connector for this Unified API."""


class TLSSupportTypedDict(TypedDict):
    type: NotRequired[str]
    description: NotRequired[str]
    r"""Description of the TLS support"""


class TLSSupport(BaseModel):
    type: Optional[str] = None

    description: Optional[str] = None
    r"""Description of the TLS support"""


class ConnectorTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the connector."""
    name: NotRequired[str]
    r"""Name of the connector."""
    status: NotRequired[ConnectorStatus]
    r"""Status of the connector. Connectors with status live or beta are callable."""
    description: NotRequired[Nullable[str]]
    r"""A description of the object."""
    icon_url: NotRequired[str]
    r"""Link to a small square icon for the connector."""
    logo_url: NotRequired[str]
    r"""Link to the full logo for the connector."""
    website_url: NotRequired[str]
    r"""Link to the connector's website."""
    signup_url: NotRequired[str]
    r"""Link to the connector's signup page."""
    partner_signup_url: NotRequired[str]
    r"""Link to the connector's partner program signup page."""
    free_trial_available: NotRequired[bool]
    r"""Set to `true` when the connector offers a free trial. Use `signup_url` to sign up for a free trial"""
    auth_type: NotRequired[ConnectorAuthType]
    r"""Type of authorization used by the connector"""
    auth_only: NotRequired[bool]
    r"""Indicates whether a connector only supports authentication. In this case the connector is not mapped to a Unified API, but can be used with the Proxy API"""
    blind_mapped: NotRequired[bool]
    r"""Set to `true` when connector was implemented from downstream docs only and without API access. This state indicates that integration will require Apideck support, and access to downstream API to validate mapping quality."""
    oauth_grant_type: NotRequired[ConnectorOauthGrantType]
    r"""OAuth grant type used by the connector. More info: https://oauth.net/2/grant-types"""
    oauth_credentials_source: NotRequired[OauthCredentialsSource]
    r"""Location of the OAuth client credentials. For most connectors the OAuth client credentials are stored on integration and managed by the application owner. For others they are stored on connection and managed by the consumer in Vault."""
    oauth_scopes: NotRequired[List[OauthScopesTypedDict]]
    r"""List of OAuth Scopes available for this connector."""
    custom_scopes: NotRequired[bool]
    r"""Set to `true` when connector allows the definition of custom scopes."""
    has_sandbox_credentials: NotRequired[bool]
    r"""Indicates whether Apideck Sandbox OAuth credentials are available."""
    settings: NotRequired[List[ConnectorSettingTypedDict]]
    service_id: NotRequired[str]
    r"""Service provider identifier"""
    unified_apis: NotRequired[List[UnifiedApisTypedDict]]
    r"""List of Unified APIs that feature this connector."""
    supported_resources: NotRequired[List[LinkedConnectorResourceTypedDict]]
    r"""List of resources that are supported on the connector."""
    configurable_resources: NotRequired[List[str]]
    r"""List of resources that have settings that can be configured."""
    supported_events: NotRequired[List[ConnectorEventTypedDict]]
    r"""List of events that are supported on the connector across all Unified APIs."""
    webhook_support: NotRequired[WebhookSupportTypedDict]
    r"""How webhooks are supported for the connector. Sometimes the connector natively supports webhooks, other times Apideck virtualizes them based on polling."""
    schema_support: NotRequired[SchemaSupportTypedDict]
    r"""When a connector has schema_support, a call can be made to retrieve a json schema that describes a downstream resource."""
    docs: NotRequired[List[ConnectorDocTypedDict]]
    tls_support: NotRequired[TLSSupportTypedDict]


class Connector(BaseModel):
    id: Optional[str] = None
    r"""ID of the connector."""

    name: Optional[str] = None
    r"""Name of the connector."""

    status: Optional[ConnectorStatus] = None
    r"""Status of the connector. Connectors with status live or beta are callable."""

    description: OptionalNullable[str] = UNSET
    r"""A description of the object."""

    icon_url: Optional[str] = None
    r"""Link to a small square icon for the connector."""

    logo_url: Optional[str] = None
    r"""Link to the full logo for the connector."""

    website_url: Optional[str] = None
    r"""Link to the connector's website."""

    signup_url: Optional[str] = None
    r"""Link to the connector's signup page."""

    partner_signup_url: Optional[str] = None
    r"""Link to the connector's partner program signup page."""

    free_trial_available: Optional[bool] = None
    r"""Set to `true` when the connector offers a free trial. Use `signup_url` to sign up for a free trial"""

    auth_type: Optional[ConnectorAuthType] = None
    r"""Type of authorization used by the connector"""

    auth_only: Optional[bool] = None
    r"""Indicates whether a connector only supports authentication. In this case the connector is not mapped to a Unified API, but can be used with the Proxy API"""

    blind_mapped: Optional[bool] = None
    r"""Set to `true` when connector was implemented from downstream docs only and without API access. This state indicates that integration will require Apideck support, and access to downstream API to validate mapping quality."""

    oauth_grant_type: Optional[ConnectorOauthGrantType] = None
    r"""OAuth grant type used by the connector. More info: https://oauth.net/2/grant-types"""

    oauth_credentials_source: Optional[OauthCredentialsSource] = None
    r"""Location of the OAuth client credentials. For most connectors the OAuth client credentials are stored on integration and managed by the application owner. For others they are stored on connection and managed by the consumer in Vault."""

    oauth_scopes: Optional[List[OauthScopes]] = None
    r"""List of OAuth Scopes available for this connector."""

    custom_scopes: Optional[bool] = None
    r"""Set to `true` when connector allows the definition of custom scopes."""

    has_sandbox_credentials: Optional[bool] = None
    r"""Indicates whether Apideck Sandbox OAuth credentials are available."""

    settings: Optional[List[ConnectorSetting]] = None

    service_id: Optional[str] = None
    r"""Service provider identifier"""

    unified_apis: Optional[List[UnifiedApis]] = None
    r"""List of Unified APIs that feature this connector."""

    supported_resources: Optional[List[LinkedConnectorResource]] = None
    r"""List of resources that are supported on the connector."""

    configurable_resources: Optional[List[str]] = None
    r"""List of resources that have settings that can be configured."""

    supported_events: Optional[List[ConnectorEvent]] = None
    r"""List of events that are supported on the connector across all Unified APIs."""

    webhook_support: Optional[WebhookSupport] = None
    r"""How webhooks are supported for the connector. Sometimes the connector natively supports webhooks, other times Apideck virtualizes them based on polling."""

    schema_support: Optional[SchemaSupport] = None
    r"""When a connector has schema_support, a call can be made to retrieve a json schema that describes a downstream resource."""

    docs: Optional[List[ConnectorDoc]] = None

    tls_support: Optional[TLSSupport] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "status",
            "description",
            "icon_url",
            "logo_url",
            "website_url",
            "signup_url",
            "partner_signup_url",
            "free_trial_available",
            "auth_type",
            "auth_only",
            "blind_mapped",
            "oauth_grant_type",
            "oauth_credentials_source",
            "oauth_scopes",
            "custom_scopes",
            "has_sandbox_credentials",
            "settings",
            "service_id",
            "unified_apis",
            "supported_resources",
            "configurable_resources",
            "supported_events",
            "webhook_support",
            "schema_support",
            "docs",
            "tls_support",
        ]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
