"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .paginationcoverage import PaginationCoverage, PaginationCoverageTypedDict
from .resourcestatus import ResourceStatus
from .supportedproperty import SupportedProperty, SupportedPropertyTypedDict
from apideck_unify.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ConnectorResourceTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the resource, typically a lowercased version of name."""
    name: NotRequired[str]
    r"""Name of the resource (plural)"""
    downstream_id: NotRequired[str]
    r"""ID of the resource in the Connector's API (downstream)"""
    downstream_name: NotRequired[str]
    r"""Name of the resource in the Connector's API (downstream)"""
    status: NotRequired[ResourceStatus]
    r"""Status of the resource. Resources with status live or beta are callable."""
    pagination_supported: NotRequired[bool]
    r"""Indicates if pagination (cursor and limit parameters) is supported on the list endpoint of the resource."""
    pagination: NotRequired[PaginationCoverageTypedDict]
    custom_fields_supported: NotRequired[bool]
    r"""Indicates if custom fields are supported on this resource."""
    supported_operations: NotRequired[List[str]]
    r"""List of supported operations on the resource."""
    downstream_unsupported_operations: NotRequired[List[str]]
    r"""List of operations that are not supported on the downstream."""
    supported_filters: NotRequired[List[str]]
    r"""Supported filters on the list endpoint of the resource."""
    supported_sort_by: NotRequired[List[str]]
    r"""Supported sorting properties on the list endpoint of the resource."""
    supported_fields: NotRequired[List[SupportedPropertyTypedDict]]
    r"""Supported fields on the detail endpoint."""
    supported_list_fields: NotRequired[List[SupportedPropertyTypedDict]]
    r"""Supported fields on the list endpoint."""


class ConnectorResource(BaseModel):
    id: Optional[str] = None
    r"""ID of the resource, typically a lowercased version of name."""

    name: Optional[str] = None
    r"""Name of the resource (plural)"""

    downstream_id: Optional[str] = None
    r"""ID of the resource in the Connector's API (downstream)"""

    downstream_name: Optional[str] = None
    r"""Name of the resource in the Connector's API (downstream)"""

    status: Optional[ResourceStatus] = None
    r"""Status of the resource. Resources with status live or beta are callable."""

    pagination_supported: Optional[bool] = None
    r"""Indicates if pagination (cursor and limit parameters) is supported on the list endpoint of the resource."""

    pagination: Optional[PaginationCoverage] = None

    custom_fields_supported: Optional[bool] = None
    r"""Indicates if custom fields are supported on this resource."""

    supported_operations: Optional[List[str]] = None
    r"""List of supported operations on the resource."""

    downstream_unsupported_operations: Optional[List[str]] = None
    r"""List of operations that are not supported on the downstream."""

    supported_filters: Optional[List[str]] = None
    r"""Supported filters on the list endpoint of the resource."""

    supported_sort_by: Optional[List[str]] = None
    r"""Supported sorting properties on the list endpoint of the resource."""

    supported_fields: Optional[List[SupportedProperty]] = None
    r"""Supported fields on the detail endpoint."""

    supported_list_fields: Optional[List[SupportedProperty]] = None
    r"""Supported fields on the list endpoint."""
