"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class CustomMappingTypedDict(TypedDict):
    id: NotRequired[str]
    r"""Target Field ID"""
    label: NotRequired[str]
    r"""Target Field name to use as a label"""
    description: NotRequired[Nullable[str]]
    r"""Target Field description"""
    value: NotRequired[str]
    r"""Target Field Mapping value"""
    key: NotRequired[str]
    r"""Target Field Key"""
    required: NotRequired[bool]
    r"""Target Field Mapping is required"""
    custom_field: NotRequired[bool]
    r"""This mapping represents a finder for a custom field"""
    consumer_id: NotRequired[Nullable[str]]
    r"""Consumer ID"""
    example: NotRequired[Nullable[str]]
    r"""Target Field Mapping example value from downstream"""


class CustomMapping(BaseModel):
    id: Optional[str] = None
    r"""Target Field ID"""

    label: Optional[str] = None
    r"""Target Field name to use as a label"""

    description: OptionalNullable[str] = UNSET
    r"""Target Field description"""

    value: Optional[str] = None
    r"""Target Field Mapping value"""

    key: Optional[str] = None
    r"""Target Field Key"""

    required: Optional[bool] = None
    r"""Target Field Mapping is required"""

    custom_field: Optional[bool] = None
    r"""This mapping represents a finder for a custom field"""

    consumer_id: OptionalNullable[str] = UNSET
    r"""Consumer ID"""

    example: OptionalNullable[str] = UNSET
    r"""Target Field Mapping example value from downstream"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "label",
            "description",
            "value",
            "key",
            "required",
            "custom_field",
            "consumer_id",
            "example",
        ]
        nullable_fields = ["description", "consumer_id", "example"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
