"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CustomObjectFieldsTypedDict(TypedDict):
    name: NotRequired[str]
    value: NotRequired[str]


class CustomObjectFields(BaseModel):
    name: Optional[str] = None

    value: Optional[str] = None


class CustomObjectTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The unique identifier of the custom object"""
    owner_id: NotRequired[str]
    r"""The unique identifier of the owner of the custom object"""
    name: NotRequired[Nullable[str]]
    r"""The name of the custom object"""
    fields: NotRequired[List[CustomObjectFieldsTypedDict]]
    updated_by: NotRequired[str]
    r"""The unique identifier of the user who last updated the custom object"""
    created_by: NotRequired[str]
    r"""The unique identifier of the user who created the custom object"""
    updated_at: NotRequired[Nullable[str]]
    r"""The timestamp when the custom object was last updated"""
    created_at: NotRequired[Nullable[str]]
    r"""The timestamp when the custom object was created"""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class CustomObject(BaseModel):
    id: Optional[str] = None
    r"""The unique identifier of the custom object"""

    owner_id: Optional[str] = None
    r"""The unique identifier of the owner of the custom object"""

    name: OptionalNullable[str] = UNSET
    r"""The name of the custom object"""

    fields: Optional[List[CustomObjectFields]] = None

    updated_by: Optional[str] = None
    r"""The unique identifier of the user who last updated the custom object"""

    created_by: Optional[str] = None
    r"""The unique identifier of the user who created the custom object"""

    updated_at: OptionalNullable[str] = UNSET
    r"""The timestamp when the custom object was last updated"""

    created_at: OptionalNullable[str] = UNSET
    r"""The timestamp when the custom object was created"""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "owner_id",
            "name",
            "fields",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = ["name", "updated_at", "created_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomObjectInputTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The name of the custom object"""
    fields: NotRequired[List[CustomObjectFieldsTypedDict]]
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class CustomObjectInput(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The name of the custom object"""

    fields: Optional[List[CustomObjectFields]] = None

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "fields", "pass_through"]
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
