"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CustomObjectSchemaType(str, Enum):
    STRING = "string"
    NUMBER = "number"
    INTEGER = "integer"
    BOOLEAN = "boolean"
    DATE = "date"
    DATETIME = "datetime"
    CURRENCY = "currency"
    EMAIL = "email"
    PHONE = "phone"
    REFERENCE = "reference"
    SELECT = "select"
    MULTISELECT = "multiselect"


class CustomObjectSchemaOptionsTypedDict(TypedDict):
    value: NotRequired[str]
    label: NotRequired[str]


class CustomObjectSchemaOptions(BaseModel):
    value: Optional[str] = None

    label: Optional[str] = None


class FieldsTypedDict(TypedDict):
    id: NotRequired[str]
    name: NotRequired[str]
    description: NotRequired[Nullable[str]]
    type: NotRequired[CustomObjectSchemaType]
    required: NotRequired[bool]
    options: NotRequired[Nullable[List[CustomObjectSchemaOptionsTypedDict]]]
    r"""Options for select and multiselect types"""
    default_value: NotRequired[Nullable[str]]
    r"""Default value for the field"""


class Fields(BaseModel):
    id: Optional[str] = None

    name: Optional[str] = None

    description: OptionalNullable[str] = UNSET

    type: Optional[CustomObjectSchemaType] = None

    required: Optional[bool] = None

    options: OptionalNullable[List[CustomObjectSchemaOptions]] = UNSET
    r"""Options for select and multiselect types"""

    default_value: OptionalNullable[str] = UNSET
    r"""Default value for the field"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "description",
            "type",
            "required",
            "options",
            "default_value",
        ]
        nullable_fields = ["description", "options", "default_value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomObjectSchemaTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The unique identifier of the custom object schema"""
    name: NotRequired[Nullable[str]]
    r"""The name of the custom object schema"""
    description: NotRequired[Nullable[str]]
    r"""The description of the custom object schema"""
    fields: NotRequired[List[FieldsTypedDict]]
    r"""The fields defined in the schema"""
    visible: NotRequired[Nullable[bool]]
    r"""Whether the custom object schema is visible in the UI"""
    active: NotRequired[Nullable[bool]]
    r"""Whether the custom object schema is active"""
    created_by: NotRequired[Nullable[str]]
    r"""The ID of the user who created the custom object schema"""
    updated_by: NotRequired[Nullable[str]]
    r"""The ID of the user who last updated the custom object schema"""
    updated_at: NotRequired[Nullable[str]]
    r"""The timestamp when the custom object schema was last updated"""
    created_at: NotRequired[Nullable[str]]
    r"""The timestamp when the custom object schema was created"""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class CustomObjectSchema(BaseModel):
    id: Optional[str] = None
    r"""The unique identifier of the custom object schema"""

    name: OptionalNullable[str] = UNSET
    r"""The name of the custom object schema"""

    description: OptionalNullable[str] = UNSET
    r"""The description of the custom object schema"""

    fields: Optional[List[Fields]] = None
    r"""The fields defined in the schema"""

    visible: OptionalNullable[bool] = UNSET
    r"""Whether the custom object schema is visible in the UI"""

    active: OptionalNullable[bool] = UNSET
    r"""Whether the custom object schema is active"""

    created_by: OptionalNullable[str] = UNSET
    r"""The ID of the user who created the custom object schema"""

    updated_by: OptionalNullable[str] = UNSET
    r"""The ID of the user who last updated the custom object schema"""

    updated_at: OptionalNullable[str] = UNSET
    r"""The timestamp when the custom object schema was last updated"""

    created_at: OptionalNullable[str] = UNSET
    r"""The timestamp when the custom object schema was created"""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "description",
            "fields",
            "visible",
            "active",
            "created_by",
            "updated_by",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "name",
            "description",
            "visible",
            "active",
            "created_by",
            "updated_by",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomObjectSchemaInputTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The name of the custom object schema"""
    description: NotRequired[Nullable[str]]
    r"""The description of the custom object schema"""
    fields: NotRequired[List[FieldsTypedDict]]
    r"""The fields defined in the schema"""
    visible: NotRequired[Nullable[bool]]
    r"""Whether the custom object schema is visible in the UI"""
    active: NotRequired[Nullable[bool]]
    r"""Whether the custom object schema is active"""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class CustomObjectSchemaInput(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The name of the custom object schema"""

    description: OptionalNullable[str] = UNSET
    r"""The description of the custom object schema"""

    fields: Optional[List[Fields]] = None
    r"""The fields defined in the schema"""

    visible: OptionalNullable[bool] = UNSET
    r"""Whether the custom object schema is visible in the UI"""

    active: OptionalNullable[bool] = UNSET
    r"""Whether the custom object schema is active"""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "description",
            "fields",
            "visible",
            "active",
            "pass_through",
        ]
        nullable_fields = ["name", "description", "visible", "active"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
