"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from .email import Email, EmailTypedDict
from .linkedecommerceorder import LinkedEcommerceOrder, LinkedEcommerceOrderTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class CustomerStatus(str, Enum):
    r"""The current status of the customer"""

    ACTIVE = "active"
    ARCHIVED = "archived"


class EcommerceCustomerType(str, Enum):
    BILLING = "billing"
    SHIPPING = "shipping"
    OTHER = "other"


class AddressesTypedDict(TypedDict):
    type: NotRequired[EcommerceCustomerType]
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    line1: NotRequired[Nullable[str]]
    r"""First line of the street address of the customer"""
    line2: NotRequired[Nullable[str]]
    r"""Second line of the street address of the customer"""
    city: NotRequired[Nullable[str]]
    r"""City of the customer"""
    state: NotRequired[Nullable[str]]
    r"""State of the customer"""
    postal_code: NotRequired[Nullable[str]]
    r"""Postal code of the customer"""
    country: NotRequired[Nullable[str]]
    r"""Country of the customer"""


class Addresses(BaseModel):
    type: Optional[EcommerceCustomerType] = None

    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    line1: OptionalNullable[str] = UNSET
    r"""First line of the street address of the customer"""

    line2: OptionalNullable[str] = UNSET
    r"""Second line of the street address of the customer"""

    city: OptionalNullable[str] = UNSET
    r"""City of the customer"""

    state: OptionalNullable[str] = UNSET
    r"""State of the customer"""

    postal_code: OptionalNullable[str] = UNSET
    r"""Postal code of the customer"""

    country: OptionalNullable[str] = UNSET
    r"""Country of the customer"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "id",
            "line1",
            "line2",
            "city",
            "state",
            "postal_code",
            "country",
        ]
        nullable_fields = [
            "id",
            "line1",
            "line2",
            "city",
            "state",
            "postal_code",
            "country",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EcommerceCustomerTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    name: NotRequired[Nullable[str]]
    r"""Full name of the customer"""
    first_name: NotRequired[Nullable[str]]
    r"""First name of the customer"""
    last_name: NotRequired[Nullable[str]]
    r"""Last name of the customer"""
    company_name: NotRequired[Nullable[str]]
    r"""Company name of the customer"""
    status: NotRequired[Nullable[CustomerStatus]]
    r"""The current status of the customer"""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    emails: NotRequired[Nullable[List[EmailTypedDict]]]
    r"""An array of email addresses for the customer."""
    phone_numbers: NotRequired[Nullable[List[PhoneNumberTypedDict]]]
    r"""An array of phone numbers for the customer."""
    addresses: NotRequired[List[AddressesTypedDict]]
    r"""An array of addresses for the customer."""
    orders: NotRequired[List[LinkedEcommerceOrderTypedDict]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""


class EcommerceCustomer(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    name: OptionalNullable[str] = UNSET
    r"""Full name of the customer"""

    first_name: OptionalNullable[str] = UNSET
    r"""First name of the customer"""

    last_name: OptionalNullable[str] = UNSET
    r"""Last name of the customer"""

    company_name: OptionalNullable[str] = UNSET
    r"""Company name of the customer"""

    status: OptionalNullable[CustomerStatus] = UNSET
    r"""The current status of the customer"""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    emails: OptionalNullable[List[Email]] = UNSET
    r"""An array of email addresses for the customer."""

    phone_numbers: OptionalNullable[List[PhoneNumber]] = UNSET
    r"""An array of phone numbers for the customer."""

    addresses: Optional[List[Addresses]] = None
    r"""An array of addresses for the customer."""

    orders: Optional[List[LinkedEcommerceOrder]] = None

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "first_name",
            "last_name",
            "company_name",
            "status",
            "currency",
            "emails",
            "phone_numbers",
            "addresses",
            "orders",
            "custom_mappings",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "name",
            "first_name",
            "last_name",
            "company_name",
            "status",
            "currency",
            "emails",
            "phone_numbers",
            "custom_mappings",
            "created_at",
            "updated_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
