"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .linkedfolder import LinkedFolder, LinkedFolderTypedDict
from .owner import Owner, OwnerTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class FolderTypedDict(TypedDict):
    name: str
    r"""The name of the folder"""
    parent_folders: List[LinkedFolderTypedDict]
    r"""The parent folders of the file, starting from the root"""
    id: NotRequired[str]
    r"""A unique identifier for an object."""
    downstream_id: NotRequired[Nullable[str]]
    r"""The third-party API ID of original entity"""
    description: NotRequired[Nullable[str]]
    r"""Optional description of the folder"""
    path: NotRequired[Nullable[str]]
    r"""The full path of the folder (includes the folder name)"""
    size: NotRequired[Nullable[int]]
    r"""The size of the folder in bytes"""
    downloadable: NotRequired[Nullable[bool]]
    r"""Whether the current user can download the contents of this folder"""
    owner: NotRequired[OwnerTypedDict]
    parent_folders_complete: NotRequired[bool]
    r"""Whether the list of parent folder is complete. Some connectors only return the direct parent of a folder"""
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""


class Folder(BaseModel):
    name: str
    r"""The name of the folder"""

    parent_folders: List[LinkedFolder]
    r"""The parent folders of the file, starting from the root"""

    id: Optional[str] = None
    r"""A unique identifier for an object."""

    downstream_id: OptionalNullable[str] = UNSET
    r"""The third-party API ID of original entity"""

    description: OptionalNullable[str] = UNSET
    r"""Optional description of the folder"""

    path: OptionalNullable[str] = UNSET
    r"""The full path of the folder (includes the folder name)"""

    size: OptionalNullable[int] = UNSET
    r"""The size of the folder in bytes"""

    downloadable: OptionalNullable[bool] = UNSET
    r"""Whether the current user can download the contents of this folder"""

    owner: Optional[Owner] = None

    parent_folders_complete: Optional[bool] = None
    r"""Whether the list of parent folder is complete. Some connectors only return the direct parent of a folder"""

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "downstream_id",
            "description",
            "path",
            "size",
            "downloadable",
            "owner",
            "parent_folders_complete",
            "custom_mappings",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
        ]
        nullable_fields = [
            "downstream_id",
            "description",
            "path",
            "size",
            "downloadable",
            "custom_mappings",
            "updated_by",
            "created_by",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
