"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customfield import CustomField, CustomFieldTypedDict
from .linkedinvoiceitem import LinkedInvoiceItem, LinkedInvoiceItemTypedDict
from .linkedledgeraccount import LinkedLedgerAccount, LinkedLedgerAccountTypedDict
from .linkedtaxrate import LinkedTaxRate, LinkedTaxRateTypedDict
from .linkedtaxrate_input import LinkedTaxRateInput, LinkedTaxRateInputTypedDict
from .linkedtrackingcategory import (
    LinkedTrackingCategory,
    LinkedTrackingCategoryTypedDict,
)
from .linkedworktag import LinkedWorktag, LinkedWorktagTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import date, datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class InvoiceLineItemType(str, Enum):
    r"""Item type"""

    SALES_ITEM = "sales_item"
    DISCOUNT = "discount"
    INFO = "info"
    SUB_TOTAL = "sub_total"
    SERVICE = "service"
    OTHER = "other"


class InvoiceLineItemTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    row_id: NotRequired[str]
    r"""Row ID"""
    code: NotRequired[Nullable[str]]
    r"""User defined item code"""
    line_number: NotRequired[Nullable[int]]
    r"""Line number of the resource"""
    description: NotRequired[Nullable[str]]
    r"""User defined description"""
    type: NotRequired[Nullable[InvoiceLineItemType]]
    r"""Item type"""
    tax_amount: NotRequired[Nullable[float]]
    r"""Tax amount"""
    total_amount: NotRequired[Nullable[float]]
    r"""Total amount of the line item"""
    quantity: NotRequired[Nullable[float]]
    unit_price: NotRequired[Nullable[float]]
    unit_of_measure: NotRequired[Nullable[str]]
    r"""Description of the unit type the item is sold as, ie: kg, hour."""
    discount_percentage: NotRequired[Nullable[float]]
    r"""Discount percentage applied to the line item when supported downstream."""
    discount_amount: NotRequired[Nullable[float]]
    r"""Discount amount applied to the line item when supported downstream."""
    service_date: NotRequired[Nullable[date]]
    r"""Date on which the service was provided or performed - YYYY-MM-DD."""
    category_id: NotRequired[Nullable[str]]
    r"""ID of the category of the line item"""
    location_id: NotRequired[Nullable[str]]
    r"""The ID of the location"""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    subsidiary_id: NotRequired[Nullable[str]]
    r"""The ID of the subsidiary"""
    shipping_id: NotRequired[Nullable[str]]
    r"""ID of the shipping of the line item"""
    memo: NotRequired[Nullable[str]]
    r"""Memo"""
    prepaid: NotRequired[Nullable[bool]]
    r"""Whether the line item is prepaid"""
    item: NotRequired[LinkedInvoiceItemTypedDict]
    tax_applicable_on: NotRequired[Nullable[str]]
    r"""Tax applicable on"""
    tax_recoverability: NotRequired[Nullable[str]]
    r"""Tax recoverability"""
    tax_method: NotRequired[Nullable[str]]
    r"""Method of tax calculation"""
    worktags: NotRequired[List[Nullable[LinkedWorktagTypedDict]]]
    r"""Worktags of the line item. This is currently only supported in Workday."""
    tax_rate: NotRequired[LinkedTaxRateTypedDict]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    ledger_account: NotRequired[Nullable[LinkedLedgerAccountTypedDict]]
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""
    updated_by: NotRequired[Nullable[str]]
    r"""The user who last updated the object."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""


class InvoiceLineItem(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    row_id: Optional[str] = None
    r"""Row ID"""

    code: OptionalNullable[str] = UNSET
    r"""User defined item code"""

    line_number: OptionalNullable[int] = UNSET
    r"""Line number of the resource"""

    description: OptionalNullable[str] = UNSET
    r"""User defined description"""

    type: OptionalNullable[InvoiceLineItemType] = UNSET
    r"""Item type"""

    tax_amount: OptionalNullable[float] = UNSET
    r"""Tax amount"""

    total_amount: OptionalNullable[float] = UNSET
    r"""Total amount of the line item"""

    quantity: OptionalNullable[float] = UNSET

    unit_price: OptionalNullable[float] = UNSET

    unit_of_measure: OptionalNullable[str] = UNSET
    r"""Description of the unit type the item is sold as, ie: kg, hour."""

    discount_percentage: OptionalNullable[float] = UNSET
    r"""Discount percentage applied to the line item when supported downstream."""

    discount_amount: OptionalNullable[float] = UNSET
    r"""Discount amount applied to the line item when supported downstream."""

    service_date: OptionalNullable[date] = UNSET
    r"""Date on which the service was provided or performed - YYYY-MM-DD."""

    category_id: OptionalNullable[str] = UNSET
    r"""ID of the category of the line item"""

    location_id: OptionalNullable[str] = UNSET
    r"""The ID of the location"""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    subsidiary_id: OptionalNullable[str] = UNSET
    r"""The ID of the subsidiary"""

    shipping_id: OptionalNullable[str] = UNSET
    r"""ID of the shipping of the line item"""

    memo: OptionalNullable[str] = UNSET
    r"""Memo"""

    prepaid: OptionalNullable[bool] = UNSET
    r"""Whether the line item is prepaid"""

    item: Optional[LinkedInvoiceItem] = None

    tax_applicable_on: OptionalNullable[str] = UNSET
    r"""Tax applicable on"""

    tax_recoverability: OptionalNullable[str] = UNSET
    r"""Tax recoverability"""

    tax_method: OptionalNullable[str] = UNSET
    r"""Method of tax calculation"""

    worktags: Optional[List[Nullable[LinkedWorktag]]] = None
    r"""Worktags of the line item. This is currently only supported in Workday."""

    tax_rate: Optional[LinkedTaxRate] = None

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    ledger_account: OptionalNullable[LinkedLedgerAccount] = UNSET

    custom_fields: Optional[List[CustomField]] = None

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    updated_by: OptionalNullable[str] = UNSET
    r"""The user who last updated the object."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "row_id",
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "service_date",
            "category_id",
            "location_id",
            "department_id",
            "subsidiary_id",
            "shipping_id",
            "memo",
            "prepaid",
            "item",
            "tax_applicable_on",
            "tax_recoverability",
            "tax_method",
            "worktags",
            "tax_rate",
            "tracking_categories",
            "ledger_account",
            "custom_fields",
            "row_version",
            "updated_by",
            "created_by",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "id",
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "service_date",
            "category_id",
            "location_id",
            "department_id",
            "subsidiary_id",
            "shipping_id",
            "memo",
            "prepaid",
            "tax_applicable_on",
            "tax_recoverability",
            "tax_method",
            "tracking_categories",
            "ledger_account",
            "row_version",
            "updated_by",
            "created_by",
            "created_at",
            "updated_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InvoiceLineItemInputTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    row_id: NotRequired[str]
    r"""Row ID"""
    code: NotRequired[Nullable[str]]
    r"""User defined item code"""
    line_number: NotRequired[Nullable[int]]
    r"""Line number of the resource"""
    description: NotRequired[Nullable[str]]
    r"""User defined description"""
    type: NotRequired[Nullable[InvoiceLineItemType]]
    r"""Item type"""
    tax_amount: NotRequired[Nullable[float]]
    r"""Tax amount"""
    total_amount: NotRequired[Nullable[float]]
    r"""Total amount of the line item"""
    quantity: NotRequired[Nullable[float]]
    unit_price: NotRequired[Nullable[float]]
    unit_of_measure: NotRequired[Nullable[str]]
    r"""Description of the unit type the item is sold as, ie: kg, hour."""
    discount_percentage: NotRequired[Nullable[float]]
    r"""Discount percentage applied to the line item when supported downstream."""
    discount_amount: NotRequired[Nullable[float]]
    r"""Discount amount applied to the line item when supported downstream."""
    service_date: NotRequired[Nullable[date]]
    r"""Date on which the service was provided or performed - YYYY-MM-DD."""
    category_id: NotRequired[Nullable[str]]
    r"""ID of the category of the line item"""
    location_id: NotRequired[Nullable[str]]
    r"""The ID of the location"""
    department_id: NotRequired[Nullable[str]]
    r"""The ID of the department"""
    subsidiary_id: NotRequired[Nullable[str]]
    r"""The ID of the subsidiary"""
    shipping_id: NotRequired[Nullable[str]]
    r"""ID of the shipping of the line item"""
    memo: NotRequired[Nullable[str]]
    r"""Memo"""
    prepaid: NotRequired[Nullable[bool]]
    r"""Whether the line item is prepaid"""
    item: NotRequired[LinkedInvoiceItemTypedDict]
    tax_applicable_on: NotRequired[Nullable[str]]
    r"""Tax applicable on"""
    tax_recoverability: NotRequired[Nullable[str]]
    r"""Tax recoverability"""
    tax_method: NotRequired[Nullable[str]]
    r"""Method of tax calculation"""
    worktags: NotRequired[List[Nullable[LinkedWorktagTypedDict]]]
    r"""Worktags of the line item. This is currently only supported in Workday."""
    tax_rate: NotRequired[LinkedTaxRateInputTypedDict]
    tracking_categories: NotRequired[
        Nullable[List[Nullable[LinkedTrackingCategoryTypedDict]]]
    ]
    r"""A list of linked tracking categories."""
    ledger_account: NotRequired[Nullable[LinkedLedgerAccountTypedDict]]
    custom_fields: NotRequired[List[CustomFieldTypedDict]]
    row_version: NotRequired[Nullable[str]]
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""


class InvoiceLineItemInput(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    row_id: Optional[str] = None
    r"""Row ID"""

    code: OptionalNullable[str] = UNSET
    r"""User defined item code"""

    line_number: OptionalNullable[int] = UNSET
    r"""Line number of the resource"""

    description: OptionalNullable[str] = UNSET
    r"""User defined description"""

    type: OptionalNullable[InvoiceLineItemType] = UNSET
    r"""Item type"""

    tax_amount: OptionalNullable[float] = UNSET
    r"""Tax amount"""

    total_amount: OptionalNullable[float] = UNSET
    r"""Total amount of the line item"""

    quantity: OptionalNullable[float] = UNSET

    unit_price: OptionalNullable[float] = UNSET

    unit_of_measure: OptionalNullable[str] = UNSET
    r"""Description of the unit type the item is sold as, ie: kg, hour."""

    discount_percentage: OptionalNullable[float] = UNSET
    r"""Discount percentage applied to the line item when supported downstream."""

    discount_amount: OptionalNullable[float] = UNSET
    r"""Discount amount applied to the line item when supported downstream."""

    service_date: OptionalNullable[date] = UNSET
    r"""Date on which the service was provided or performed - YYYY-MM-DD."""

    category_id: OptionalNullable[str] = UNSET
    r"""ID of the category of the line item"""

    location_id: OptionalNullable[str] = UNSET
    r"""The ID of the location"""

    department_id: OptionalNullable[str] = UNSET
    r"""The ID of the department"""

    subsidiary_id: OptionalNullable[str] = UNSET
    r"""The ID of the subsidiary"""

    shipping_id: OptionalNullable[str] = UNSET
    r"""ID of the shipping of the line item"""

    memo: OptionalNullable[str] = UNSET
    r"""Memo"""

    prepaid: OptionalNullable[bool] = UNSET
    r"""Whether the line item is prepaid"""

    item: Optional[LinkedInvoiceItem] = None

    tax_applicable_on: OptionalNullable[str] = UNSET
    r"""Tax applicable on"""

    tax_recoverability: OptionalNullable[str] = UNSET
    r"""Tax recoverability"""

    tax_method: OptionalNullable[str] = UNSET
    r"""Method of tax calculation"""

    worktags: Optional[List[Nullable[LinkedWorktag]]] = None
    r"""Worktags of the line item. This is currently only supported in Workday."""

    tax_rate: Optional[LinkedTaxRateInput] = None

    tracking_categories: OptionalNullable[List[Nullable[LinkedTrackingCategory]]] = (
        UNSET
    )
    r"""A list of linked tracking categories."""

    ledger_account: OptionalNullable[LinkedLedgerAccount] = UNSET

    custom_fields: Optional[List[CustomField]] = None

    row_version: OptionalNullable[str] = UNSET
    r"""A binary value used to detect updates to a object and prevent data conflicts. It is incremented each time an update is made to the object."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "row_id",
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "service_date",
            "category_id",
            "location_id",
            "department_id",
            "subsidiary_id",
            "shipping_id",
            "memo",
            "prepaid",
            "item",
            "tax_applicable_on",
            "tax_recoverability",
            "tax_method",
            "worktags",
            "tax_rate",
            "tracking_categories",
            "ledger_account",
            "custom_fields",
            "row_version",
        ]
        nullable_fields = [
            "id",
            "code",
            "line_number",
            "description",
            "type",
            "tax_amount",
            "total_amount",
            "quantity",
            "unit_price",
            "unit_of_measure",
            "discount_percentage",
            "discount_amount",
            "service_date",
            "category_id",
            "location_id",
            "department_id",
            "subsidiary_id",
            "shipping_id",
            "memo",
            "prepaid",
            "tax_applicable_on",
            "tax_recoverability",
            "tax_method",
            "tracking_categories",
            "ledger_account",
            "row_version",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
