"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .currency import Currency
from .customfield import CustomField, CustomFieldTypedDict
from .email import Email, EmailTypedDict
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .sociallink import SocialLink, SocialLinkTypedDict
from .website import Website, WebsiteTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class LeadTypedDict(TypedDict):
    name: str
    r"""Full name of the lead."""
    id: NotRequired[str]
    r"""Unique identifier for the contact."""
    company_name: NotRequired[Nullable[str]]
    r"""The name of the company the lead is associated with."""
    owner_id: NotRequired[Nullable[str]]
    r"""The owner of the lead."""
    owner_name: NotRequired[Nullable[str]]
    r"""The name of the owner of the lead."""
    company_id: NotRequired[Nullable[str]]
    r"""The company the lead is associated with."""
    contact_id: NotRequired[Nullable[str]]
    r"""The contact the lead is associated with."""
    lead_id: NotRequired[Nullable[str]]
    r"""The identifier of the lead."""
    lead_source: NotRequired[Nullable[str]]
    r"""The source of the lead."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the lead."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the lead."""
    description: NotRequired[Nullable[str]]
    r"""The description of the lead."""
    prefix: NotRequired[Nullable[str]]
    r"""The prefix of the lead."""
    title: NotRequired[Nullable[str]]
    r"""The job title of the lead."""
    language: NotRequired[Nullable[str]]
    r"""language code according to ISO 639-1. For the United States - EN"""
    status: NotRequired[Nullable[str]]
    monetary_amount: NotRequired[Nullable[float]]
    r"""The monetary amount of the lead."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    fax: NotRequired[Nullable[str]]
    r"""The fax number of the lead."""
    websites: NotRequired[List[WebsiteTypedDict]]
    addresses: NotRequired[List[AddressTypedDict]]
    social_links: NotRequired[List[SocialLinkTypedDict]]
    phone_numbers: NotRequired[List[PhoneNumberTypedDict]]
    emails: NotRequired[List[EmailTypedDict]]
    custom_fields: NotRequired[Nullable[List[CustomFieldTypedDict]]]
    tags: NotRequired[Nullable[List[str]]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    updated_at: NotRequired[Nullable[str]]
    r"""Date updated in ISO 8601 format"""
    created_at: NotRequired[Nullable[str]]
    r"""Date created in ISO 8601 format"""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Lead(BaseModel):
    name: str
    r"""Full name of the lead."""

    id: Optional[str] = None
    r"""Unique identifier for the contact."""

    company_name: OptionalNullable[str] = UNSET
    r"""The name of the company the lead is associated with."""

    owner_id: OptionalNullable[str] = UNSET
    r"""The owner of the lead."""

    owner_name: OptionalNullable[str] = UNSET
    r"""The name of the owner of the lead."""

    company_id: OptionalNullable[str] = UNSET
    r"""The company the lead is associated with."""

    contact_id: OptionalNullable[str] = UNSET
    r"""The contact the lead is associated with."""

    lead_id: OptionalNullable[str] = UNSET
    r"""The identifier of the lead."""

    lead_source: OptionalNullable[str] = UNSET
    r"""The source of the lead."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the lead."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the lead."""

    description: OptionalNullable[str] = UNSET
    r"""The description of the lead."""

    prefix: OptionalNullable[str] = UNSET
    r"""The prefix of the lead."""

    title: OptionalNullable[str] = UNSET
    r"""The job title of the lead."""

    language: OptionalNullable[str] = UNSET
    r"""language code according to ISO 639-1. For the United States - EN"""

    status: OptionalNullable[str] = UNSET

    monetary_amount: OptionalNullable[float] = UNSET
    r"""The monetary amount of the lead."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    fax: OptionalNullable[str] = UNSET
    r"""The fax number of the lead."""

    websites: Optional[List[Website]] = None

    addresses: Optional[List[Address]] = None

    social_links: Optional[List[SocialLink]] = None

    phone_numbers: Optional[List[PhoneNumber]] = None

    emails: Optional[List[Email]] = None

    custom_fields: OptionalNullable[List[CustomField]] = UNSET

    tags: OptionalNullable[List[str]] = UNSET

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    updated_at: OptionalNullable[str] = UNSET
    r"""Date updated in ISO 8601 format"""

    created_at: OptionalNullable[str] = UNSET
    r"""Date created in ISO 8601 format"""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "company_name",
            "owner_id",
            "owner_name",
            "company_id",
            "contact_id",
            "lead_id",
            "lead_source",
            "first_name",
            "last_name",
            "description",
            "prefix",
            "title",
            "language",
            "status",
            "monetary_amount",
            "currency",
            "fax",
            "websites",
            "addresses",
            "social_links",
            "phone_numbers",
            "emails",
            "custom_fields",
            "tags",
            "custom_mappings",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "company_name",
            "owner_id",
            "owner_name",
            "company_id",
            "contact_id",
            "lead_id",
            "lead_source",
            "first_name",
            "last_name",
            "description",
            "prefix",
            "title",
            "language",
            "status",
            "monetary_amount",
            "currency",
            "fax",
            "custom_fields",
            "tags",
            "custom_mappings",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
