"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class LinkedFinancialAccountAccountType(str, Enum):
    r"""The type of account being referenced. Use `ledger_account` for GL accounts from the chart of accounts, or `bank_account` for bank account entities. When not specified, the connector will use its default behavior."""

    LEDGER_ACCOUNT = "ledger_account"
    BANK_ACCOUNT = "bank_account"


class LinkedFinancialAccountTypedDict(TypedDict):
    r"""A flexible account reference that can represent either a ledger account (GL account) or a bank account, depending on the connector's requirements."""

    id: NotRequired[str]
    r"""The unique identifier for the account. This can be a ledger account ID or bank account ID depending on the `type` field."""
    type: NotRequired[Nullable[LinkedFinancialAccountAccountType]]
    r"""The type of account being referenced. Use `ledger_account` for GL accounts from the chart of accounts, or `bank_account` for bank account entities. When not specified, the connector will use its default behavior."""
    code: NotRequired[str]
    r"""The account code of the account"""
    display_id: NotRequired[Nullable[str]]
    r"""Id to be displayed."""
    account_number: NotRequired[Nullable[str]]
    r"""The bank account number"""
    name: NotRequired[str]
    r"""The name of the account."""
    downstream_id: NotRequired[Nullable[str]]
    r"""The third-party API ID of original entity"""


class LinkedFinancialAccount(BaseModel):
    r"""A flexible account reference that can represent either a ledger account (GL account) or a bank account, depending on the connector's requirements."""

    id: Optional[str] = None
    r"""The unique identifier for the account. This can be a ledger account ID or bank account ID depending on the `type` field."""

    type: OptionalNullable[LinkedFinancialAccountAccountType] = UNSET
    r"""The type of account being referenced. Use `ledger_account` for GL accounts from the chart of accounts, or `bank_account` for bank account entities. When not specified, the connector will use its default behavior."""

    code: Optional[str] = None
    r"""The account code of the account"""

    display_id: OptionalNullable[str] = UNSET
    r"""Id to be displayed."""

    account_number: OptionalNullable[str] = UNSET
    r"""The bank account number"""

    name: Optional[str] = None
    r"""The name of the account."""

    downstream_id: OptionalNullable[str] = UNSET
    r"""The third-party API ID of original entity"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "type",
            "code",
            "display_id",
            "account_number",
            "name",
            "downstream_id",
        ]
        nullable_fields = ["type", "display_id", "account_number", "downstream_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LinkedFinancialAccountInputTypedDict(TypedDict):
    r"""A flexible account reference that can represent either a ledger account (GL account) or a bank account, depending on the connector's requirements."""

    id: NotRequired[str]
    r"""The unique identifier for the account. This can be a ledger account ID or bank account ID depending on the `type` field."""
    type: NotRequired[Nullable[LinkedFinancialAccountAccountType]]
    r"""The type of account being referenced. Use `ledger_account` for GL accounts from the chart of accounts, or `bank_account` for bank account entities. When not specified, the connector will use its default behavior."""
    code: NotRequired[str]
    r"""The account code of the account"""
    display_id: NotRequired[Nullable[str]]
    r"""Id to be displayed."""
    account_number: NotRequired[Nullable[str]]
    r"""The bank account number"""


class LinkedFinancialAccountInput(BaseModel):
    r"""A flexible account reference that can represent either a ledger account (GL account) or a bank account, depending on the connector's requirements."""

    id: Optional[str] = None
    r"""The unique identifier for the account. This can be a ledger account ID or bank account ID depending on the `type` field."""

    type: OptionalNullable[LinkedFinancialAccountAccountType] = UNSET
    r"""The type of account being referenced. Use `ledger_account` for GL accounts from the chart of accounts, or `bank_account` for bank account entities. When not specified, the connector will use its default behavior."""

    code: Optional[str] = None
    r"""The account code of the account"""

    display_id: OptionalNullable[str] = UNSET
    r"""Id to be displayed."""

    account_number: OptionalNullable[str] = UNSET
    r"""The bank account number"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type", "code", "display_id", "account_number"]
        nullable_fields = ["type", "display_id", "account_number"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
