"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class LinkedTaxDetailTypedDict(TypedDict):
    type: NotRequired[str]
    r"""The type of tax."""
    number: NotRequired[Nullable[str]]
    r"""The number of the tax."""
    is_transaction_tax: NotRequired[bool]
    r"""Whether the tax is a transaction tax."""
    is_primary_tax: NotRequired[bool]
    r"""Whether the tax is a primary tax."""


class LinkedTaxDetail(BaseModel):
    type: Optional[str] = None
    r"""The type of tax."""

    number: OptionalNullable[str] = UNSET
    r"""The number of the tax."""

    is_transaction_tax: Optional[bool] = None
    r"""Whether the tax is a transaction tax."""

    is_primary_tax: Optional[bool] = None
    r"""Whether the tax is a primary tax."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "number", "is_transaction_tax", "is_primary_tax"]
        nullable_fields = ["number"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
