"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from apideck_unify.utils import FieldMetadata
from pydantic import model_serializer
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict


class LogsFilterTypedDict(TypedDict):
    connector_id: NotRequired[Nullable[str]]
    status_code: NotRequired[Nullable[float]]
    r"""Filter by a single HTTP status code. For backward compatibility - use status_codes for multiple values."""
    status_codes: NotRequired[Nullable[List[float]]]
    r"""Filter by multiple HTTP status codes. Values must be between 100-599. Maximum 50 status codes allowed."""
    exclude_unified_apis: NotRequired[Nullable[str]]


class LogsFilter(BaseModel):
    connector_id: Annotated[OptionalNullable[str], FieldMetadata(query=True)] = UNSET

    status_code: Annotated[OptionalNullable[float], FieldMetadata(query=True)] = UNSET
    r"""Filter by a single HTTP status code. For backward compatibility - use status_codes for multiple values."""

    status_codes: Annotated[
        OptionalNullable[List[float]], FieldMetadata(query=True)
    ] = UNSET
    r"""Filter by multiple HTTP status codes. Values must be between 100-599. Maximum 50 status codes allowed."""

    exclude_unified_apis: Annotated[
        OptionalNullable[str], FieldMetadata(query=True)
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "connector_id",
            "status_code",
            "status_codes",
            "exclude_unified_apis",
        ]
        nullable_fields = [
            "connector_id",
            "status_code",
            "status_codes",
            "exclude_unified_apis",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
