"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class NoteInputTypedDict(TypedDict):
    title: NotRequired[Nullable[str]]
    r"""The title of the note"""
    content: NotRequired[Nullable[str]]
    r"""The content of the note."""
    owner_id: NotRequired[Nullable[str]]
    r"""The user that owns the note."""
    contact_id: NotRequired[Nullable[str]]
    r"""The contact that is related to the note."""
    company_id: NotRequired[Nullable[str]]
    r"""The company that is related to the note."""
    opportunity_id: NotRequired[Nullable[str]]
    r"""The opportunity that is related to the note."""
    activity_id: NotRequired[Nullable[str]]
    r"""The activity that is related to the note."""
    lead_id: NotRequired[Nullable[str]]
    r"""The lead that is related to the note."""
    active: NotRequired[Nullable[bool]]
    r"""Whether the Note is active or not."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class NoteInput(BaseModel):
    title: OptionalNullable[str] = UNSET
    r"""The title of the note"""

    content: OptionalNullable[str] = UNSET
    r"""The content of the note."""

    owner_id: OptionalNullable[str] = UNSET
    r"""The user that owns the note."""

    contact_id: OptionalNullable[str] = UNSET
    r"""The contact that is related to the note."""

    company_id: OptionalNullable[str] = UNSET
    r"""The company that is related to the note."""

    opportunity_id: OptionalNullable[str] = UNSET
    r"""The opportunity that is related to the note."""

    activity_id: OptionalNullable[str] = UNSET
    r"""The activity that is related to the note."""

    lead_id: OptionalNullable[str] = UNSET
    r"""The lead that is related to the note."""

    active: OptionalNullable[bool] = UNSET
    r"""Whether the Note is active or not."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "content",
            "owner_id",
            "contact_id",
            "company_id",
            "opportunity_id",
            "activity_id",
            "lead_id",
            "active",
            "pass_through",
        ]
        nullable_fields = [
            "title",
            "content",
            "owner_id",
            "contact_id",
            "company_id",
            "opportunity_id",
            "activity_id",
            "lead_id",
            "active",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
